/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.xmp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.xmp.AbstractJpegXmpTest;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpRewriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class JpegXmpRewriteTest
extends AbstractJpegXmpTest {
    public static Stream<File> data() throws Exception {
        return JpegXmpRewriteTest.getImagesWithXmpData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testRemoveInsertUpdate(File imageFile) throws Exception {
        byte[] updated;
        byte[] noXmpFile;
        ByteSource byteSource = ByteSource.file((File)imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        String xmpXml = new JpegImageParser().getXmpXml(byteSource, (XmpImagingParameters)params);
        Assertions.assertNotNull((Object)xmpXml);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new JpegXmpRewriter().removeXmpXml(byteSource, (OutputStream)os);
            noXmpFile = os.toByteArray();
        }
        String outXmp = new JpegImageParser().getXmpXml(ByteSource.array((byte[])noXmpFile, (String)"test.jpg"), (XmpImagingParameters)params);
        Assertions.assertNull((Object)outXmp);
        String newXmpXml = "test";
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new JpegXmpRewriter().updateXmpXml(byteSource, (OutputStream)os, "test");
            updated = os.toByteArray();
        }
        String outXmp2 = new JpegImageParser().getXmpXml(ByteSource.array((byte[])updated, (String)"test.jpg"), (XmpImagingParameters)params);
        Assertions.assertNotNull((Object)outXmp2);
        Assertions.assertEquals((Object)outXmp2, (Object)"test");
        newXmpXml = "test";
        os = new ByteArrayOutputStream();
        try {
            new JpegXmpRewriter().updateXmpXml(ByteSource.array((byte[])noXmpFile, (String)"test.jpg"), (OutputStream)os, "test");
            updated = os.toByteArray();
        }
        finally {
            os.close();
        }
        outXmp2 = new JpegImageParser().getXmpXml(ByteSource.array((byte[])updated, (String)"test.jpg"), (XmpImagingParameters)params);
        Assertions.assertNotNull((Object)outXmp2);
        Assertions.assertEquals((Object)outXmp2, (Object)"test");
    }
}

