/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.BucketConfigRequest;
import com.couchbase.client.core.message.config.GetDesignDocumentsRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.net.InetAddress;
import java.util.List;

public class ConfigLocator
implements Locator {
    private long counter = 0L;

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        if (request instanceof BucketConfigRequest) {
            BucketConfigRequest req = (BucketConfigRequest)request;
            InetAddress hostname = req.hostname();
            for (Node node : nodes) {
                if (hostname != null && !node.hostname().equals(hostname)) continue;
                node.send(request);
                return;
            }
        } else {
            Node node;
            int offset;
            int i;
            int nodeSize = nodes.size();
            for (i = offset = (int)this.counter++ % nodeSize; i < nodeSize; ++i) {
                node = nodes.get(i);
                if (!this.checkNode(node, request)) continue;
                node.send(request);
                return;
            }
            for (i = 0; i < offset; ++i) {
                node = nodes.get(i);
                if (!this.checkNode(node, request)) continue;
                node.send(request);
                return;
            }
        }
        RetryHelper.retryOrCancel(env, request, responseBuffer);
    }

    protected boolean checkNode(Node node, CouchbaseRequest request) {
        return !(request instanceof GetDesignDocumentsRequest) || node.serviceEnabled(ServiceType.VIEW);
    }
}

