/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.fixedsize;

import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.AbstractInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.fixedsize.FixedSizeInvertedListTupleReference;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class FixedSizeElementInvertedListScanCursor
extends AbstractInvertedListCursor {
    protected final IBufferCache bufferCache;
    protected final int fileId;
    protected final int elementSize;
    protected int currentElementIxForScan;
    protected int currentOffsetForScan;
    protected int currentPageId;
    protected int startPageId;
    protected int endPageId;
    protected int startOff;
    protected int numElements;
    protected int numPages;
    protected final IInvertedListTupleReference tuple;
    protected ICachedPage page;
    protected boolean pinned;
    protected int pinnedPageId = -1;
    protected final IIndexCursorStats stats;

    public FixedSizeElementInvertedListScanCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IIndexCursorStats stats) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.fileId = fileId;
        int tmpSize = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            tmpSize += invListFields[i].getFixedLength();
        }
        this.elementSize = tmpSize;
        this.currentElementIxForScan = 0;
        this.currentOffsetForScan = -this.elementSize;
        this.currentPageId = 0;
        this.startPageId = 0;
        this.endPageId = 0;
        this.startOff = 0;
        this.numElements = 0;
        this.numPages = 0;
        this.tuple = new FixedSizeInvertedListTupleReference(invListFields);
        this.pinned = false;
        this.stats = stats;
    }

    public boolean doHasNext() {
        return this.currentElementIxForScan < this.numElements;
    }

    public void doNext() throws HyracksDataException {
        if (this.currentOffsetForScan + 2 * this.elementSize > this.bufferCache.getPageSize()) {
            this.currentOffsetForScan = 0;
            this.loadPages();
        } else {
            this.currentOffsetForScan += this.elementSize;
        }
        ++this.currentElementIxForScan;
        this.tuple.reset(this.page.getBuffer().array(), this.currentOffsetForScan);
    }

    @Override
    public void prepareLoadPages() throws HyracksDataException {
    }

    @Override
    public void loadPages() throws HyracksDataException {
        if (this.currentPageId == this.endPageId) {
            return;
        }
        ++this.currentPageId;
        if (this.pinned && this.pinnedPageId == this.currentPageId) {
            return;
        }
        this.unloadPages();
        this.page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.currentPageId), false);
        this.pinnedPageId = this.currentPageId;
        this.pinned = true;
        this.stats.getPageCounter().update(1L);
    }

    @Override
    public void unloadPages() throws HyracksDataException {
        if (this.pinned) {
            this.bufferCache.unpin(this.page);
            this.pinned = false;
        }
    }

    @Override
    protected void setInvListInfo(int startPageId, int endPageId, int startOff, int numElements) throws HyracksDataException {
        this.startPageId = startPageId;
        this.endPageId = endPageId;
        this.startOff = startOff;
        this.numElements = numElements;
        this.currentElementIxForScan = 0;
        this.currentOffsetForScan = startOff - this.elementSize;
        this.currentPageId = startPageId - 1;
        this.numPages = endPageId - startPageId + 1;
    }

    @Override
    public int compareTo(IInvertedListCursor invListCursor) {
        try {
            return this.numElements - invListCursor.size();
        }
        catch (HyracksDataException hde) {
            throw new IllegalStateException(hde);
        }
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public ITupleReference doGetTuple() {
        return this.tuple;
    }

    public void doClose() throws HyracksDataException {
    }

    public void doDestroy() throws HyracksDataException {
        this.unloadPages();
    }

    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        return false;
    }

    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException {
        return null;
    }

    @Override
    public String printCurrentElement(ISerializerDeserializer[] serdes) throws HyracksDataException {
        return null;
    }
}

