/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.util;

import java.util.List;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceReleaseUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private ResourceReleaseUtils() {
    }

    public static Throwable close(IIndexCursor cursor, Throwable root) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Throwable th) {
                try {
                    LOGGER.log(Level.WARN, "Failure closing a closeable resource", th);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                root = ExceptionUtils.suppress((Throwable)root, (Throwable)th);
            }
        }
        return root;
    }

    public static Throwable close(IIndexDataflowHelper indexHelper, Throwable root) {
        if (indexHelper != null) {
            try {
                indexHelper.close();
            }
            catch (Throwable th) {
                try {
                    LOGGER.log(Level.WARN, "Failure closing a closeable resource", th);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                root = ExceptionUtils.suppress((Throwable)root, (Throwable)th);
            }
        }
        return root;
    }

    public static Throwable close(List<IIndexDataflowHelper> indexHelpers, Throwable root) {
        for (int i = 0; i < indexHelpers.size(); ++i) {
            root = ResourceReleaseUtils.close(indexHelpers.get(i), root);
        }
        return root;
    }
}

