/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.values.bloomfilter.BlockSplitBloomFilter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.BloomFilterHeader;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.FileCryptoMetaData;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.BloomFilterReader;
import org.apache.parquet.hadoop.ColumnChunkPageReadStore;
import org.apache.parquet.hadoop.ColumnIndexFilterUtils;
import org.apache.parquet.hadoop.ColumnIndexStoreImpl;
import org.apache.parquet.hadoop.DictionaryPageReader;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexFilter;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFileReader.class);
    public static String PARQUET_READ_PARALLELISM = "parquet.metadata.read.parallelism";
    private final ParquetMetadataConverter converter;
    private final CRC32 crc;
    protected final SeekableInputStream f;
    private final InputFile file;
    private final ParquetReadOptions options;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;
    private final List<ColumnIndexStore> blockIndexStores;
    private final List<RowRanges> blockRowRanges;
    private ParquetMetadata footer;
    private int currentBlock = 0;
    private ColumnChunkPageReadStore currentRowGroup = null;
    private DictionaryPageReader nextDictionaryReader = null;
    private InternalFileDecryptor fileDecryptor = null;

    @Deprecated
    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(Configuration configuration, List<FileStatus> partFiles) throws IOException {
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, partFiles, false);
    }

    private static ParquetMetadataConverter.MetadataFilter filter(boolean skipRowGroups) {
        return skipRowGroups ? ParquetMetadataConverter.SKIP_ROW_GROUPS : ParquetMetadataConverter.NO_FILTER;
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(Configuration configuration, Collection<FileStatus> partFiles, boolean skipRowGroups) throws IOException {
        HashSet<Path> parents = new HashSet<Path>();
        for (FileStatus fileStatus : partFiles) {
            parents.add(fileStatus.getPath().getParent());
        }
        ArrayList summaries = new ArrayList();
        for (Path path : parents) {
            summaries.add(() -> {
                ParquetMetadata mergedMetadata = ParquetFileReader.readSummaryMetadata(configuration, path, skipRowGroups);
                if (mergedMetadata != null) {
                    List<Object> footers;
                    if (skipRowGroups) {
                        footers = new ArrayList();
                        for (FileStatus f : partFiles) {
                            footers.add(new Footer(f.getPath(), mergedMetadata));
                        }
                    } else {
                        footers = ParquetFileReader.footersFromSummaryFile(path, mergedMetadata);
                    }
                    HashMap<Path, Footer> map = new HashMap<Path, Footer>();
                    for (Footer footer : footers) {
                        Footer footer2 = new Footer(new Path(path, footer.getFile().getName()), footer.getParquetMetadata());
                        map.put(footer2.getFile(), footer2);
                    }
                    return map;
                }
                return Collections.emptyMap();
            });
        }
        HashMap hashMap = new HashMap();
        try {
            List<Map> footersFromSummaries = ParquetFileReader.runAllInParallel(configuration.getInt(PARQUET_READ_PARALLELISM, 5), summaries);
            for (Map footers : footersFromSummaries) {
                hashMap.putAll(footers);
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error reading summaries", e);
        }
        ArrayList<Footer> result = new ArrayList<Footer>(partFiles.size());
        ArrayList<FileStatus> toRead = new ArrayList<FileStatus>();
        for (FileStatus part : partFiles) {
            Footer f = (Footer)hashMap.get(part.getPath());
            if (f != null) {
                result.add(f);
                continue;
            }
            toRead.add(part);
        }
        if (toRead.size() > 0) {
            LOG.info("reading another {} footers", (Object)toRead.size());
            result.addAll(ParquetFileReader.readAllFootersInParallel(configuration, toRead, skipRowGroups));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> runAllInParallel(int parallelism, List<Callable<T>> toRun) throws ExecutionException {
        LOG.info("Initiating action with parallelism: {}", (Object)parallelism);
        ExecutorService threadPool = Executors.newFixedThreadPool(parallelism);
        try {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
            for (Callable<T> callable : toRun) {
                futures.add(threadPool.submit(callable));
            }
            ArrayList result = new ArrayList(toRun.size());
            for (Future future : futures) {
                try {
                    result.add(future.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("The thread was interrupted", e);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, List<FileStatus> partFiles) throws IOException {
        return ParquetFileReader.readAllFootersInParallel(configuration, partFiles, false);
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, List<FileStatus> partFiles, boolean skipRowGroups) throws IOException {
        ArrayList footers = new ArrayList();
        for (FileStatus currentFile : partFiles) {
            footers.add(() -> {
                try {
                    return new Footer(currentFile.getPath(), ParquetFileReader.readFooter(configuration, currentFile, ParquetFileReader.filter(skipRowGroups)));
                }
                catch (IOException e) {
                    throw new IOException("Could not read footer for file " + currentFile, e);
                }
            });
        }
        try {
            return ParquetFileReader.runAllInParallel(configuration.getInt(PARQUET_READ_PARALLELISM, 5), footers);
        }
        catch (ExecutionException e) {
            throw new IOException("Could not read footer: " + e.getMessage(), e.getCause());
        }
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus, boolean skipRowGroups) throws IOException {
        List<FileStatus> statuses = ParquetFileReader.listFiles(configuration, fileStatus);
        return ParquetFileReader.readAllFootersInParallel(configuration, statuses, skipRowGroups);
    }

    @Deprecated
    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus) throws IOException {
        return ParquetFileReader.readAllFootersInParallel(configuration, fileStatus, false);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, Path path) throws IOException {
        return ParquetFileReader.readFooters(configuration, ParquetFileReader.status(configuration, path));
    }

    private static FileStatus status(Configuration configuration, Path path) throws IOException {
        return path.getFileSystem(configuration).getFileStatus(path);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus) throws IOException {
        return ParquetFileReader.readFooters(configuration, pathStatus, false);
    }

    @Deprecated
    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus, boolean skipRowGroups) throws IOException {
        List<FileStatus> files = ParquetFileReader.listFiles(configuration, pathStatus);
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, files, skipRowGroups);
    }

    private static List<FileStatus> listFiles(Configuration conf, FileStatus fileStatus) throws IOException {
        if (fileStatus.isDir()) {
            FileSystem fs = fileStatus.getPath().getFileSystem(conf);
            FileStatus[] list = fs.listStatus(fileStatus.getPath(), (PathFilter)HiddenFileFilter.INSTANCE);
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            for (FileStatus sub : list) {
                result.addAll(ParquetFileReader.listFiles(conf, sub));
            }
            return result;
        }
        return Arrays.asList(fileStatus);
    }

    @Deprecated
    public static List<Footer> readSummaryFile(Configuration configuration, FileStatus summaryStatus) throws IOException {
        Path parent = summaryStatus.getPath().getParent();
        ParquetMetadata mergedFooters = ParquetFileReader.readFooter(configuration, summaryStatus, ParquetFileReader.filter(false));
        return ParquetFileReader.footersFromSummaryFile(parent, mergedFooters);
    }

    static ParquetMetadata readSummaryMetadata(Configuration configuration, Path basePath, boolean skipRowGroups) throws IOException {
        Path metadataFile = new Path(basePath, "_metadata");
        Path commonMetaDataFile = new Path(basePath, "_common_metadata");
        FileSystem fileSystem = basePath.getFileSystem(configuration);
        if (skipRowGroups && fileSystem.exists(commonMetaDataFile)) {
            LOG.info("reading summary file: {}", (Object)commonMetaDataFile);
            return ParquetFileReader.readFooter(configuration, commonMetaDataFile, ParquetFileReader.filter(skipRowGroups));
        }
        if (fileSystem.exists(metadataFile)) {
            LOG.info("reading summary file: {}", (Object)metadataFile);
            return ParquetFileReader.readFooter(configuration, metadataFile, ParquetFileReader.filter(skipRowGroups));
        }
        return null;
    }

    static List<Footer> footersFromSummaryFile(Path parent, ParquetMetadata mergedFooters) {
        HashMap<Path, ParquetMetadata> footers = new HashMap<Path, ParquetMetadata>();
        List<BlockMetaData> blocks = mergedFooters.getBlocks();
        for (BlockMetaData block : blocks) {
            String path = block.getPath();
            Path fullPath = new Path(parent, path);
            ParquetMetadata current = (ParquetMetadata)footers.get(fullPath);
            if (current == null) {
                current = new ParquetMetadata(mergedFooters.getFileMetaData(), new ArrayList<BlockMetaData>());
                footers.put(fullPath, current);
            }
            current.getBlocks().add(block);
        }
        ArrayList<Footer> result = new ArrayList<Footer>();
        for (Map.Entry entry : footers.entrySet()) {
            result.add(new Footer((Path)entry.getKey(), (ParquetMetadata)entry.getValue()));
        }
        return result;
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, Path file) throws IOException {
        return ParquetFileReader.readFooter(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    public static ParquetMetadata readFooter(Configuration configuration, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.readFooter(HadoopInputFile.fromPath(file, configuration), filter);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file) throws IOException {
        return ParquetFileReader.readFooter(configuration, file, ParquetMetadataConverter.NO_FILTER);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.readFooter(HadoopInputFile.fromStatus(file, configuration), filter);
    }

    @Deprecated
    public static final ParquetMetadata readFooter(InputFile file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        ParquetReadOptions options;
        if (file instanceof HadoopInputFile) {
            HadoopInputFile hadoopFile = (HadoopInputFile)file;
            options = HadoopReadOptions.builder(hadoopFile.getConfiguration(), hadoopFile.getPath()).withMetadataFilter(filter).build();
        } else {
            options = ParquetReadOptions.builder().withMetadataFilter(filter).build();
        }
        try (SeekableInputStream in = file.newStream();){
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter(file, options, in);
            return parquetMetadata;
        }
    }

    private static final ParquetMetadata readFooter(InputFile file, ParquetReadOptions options, SeekableInputStream f) throws IOException {
        ParquetMetadataConverter converter = new ParquetMetadataConverter(options);
        return ParquetFileReader.readFooter(file, options, f, converter);
    }

    private static final ParquetMetadata readFooter(InputFile file, ParquetReadOptions options, SeekableInputStream f, ParquetMetadataConverter converter) throws IOException {
        boolean encryptedFooterMode;
        long fileLen = file.getLength();
        String filePath = file.toString();
        LOG.debug("File length {}", (Object)fileLen);
        int FOOTER_LENGTH_SIZE = 4;
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + FOOTER_LENGTH_SIZE + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException(filePath + " is not a Parquet file (length is too low: " + fileLen + ")");
        }
        byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
        long fileMetadataLengthIndex = fileLen - (long)magic.length - (long)FOOTER_LENGTH_SIZE;
        LOG.debug("reading footer index at {}", (Object)fileMetadataLengthIndex);
        f.seek(fileMetadataLengthIndex);
        int fileMetadataLength = BytesUtils.readIntLittleEndian((InputStream)f);
        f.readFully(magic);
        if (Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
            encryptedFooterMode = false;
        } else if (Arrays.equals(ParquetFileWriter.EFMAGIC, magic)) {
            encryptedFooterMode = true;
        } else {
            throw new RuntimeException(filePath + " is not a Parquet file. Expected magic number at tail, but found " + Arrays.toString(magic));
        }
        long fileMetadataIndex = fileMetadataLengthIndex - (long)fileMetadataLength;
        LOG.debug("read footer length: {}, footer index: {}", (Object)fileMetadataLength, (Object)fileMetadataIndex);
        if (fileMetadataIndex < (long)magic.length || fileMetadataIndex >= fileMetadataLengthIndex) {
            throw new RuntimeException("corrupted file: the footer index is not within the file: " + fileMetadataIndex);
        }
        f.seek(fileMetadataIndex);
        FileDecryptionProperties fileDecryptionProperties = options.getDecryptionProperties();
        InternalFileDecryptor fileDecryptor = null;
        if (null != fileDecryptionProperties) {
            fileDecryptor = new InternalFileDecryptor(fileDecryptionProperties);
        }
        ByteBuffer footerBytesBuffer = ByteBuffer.allocate(fileMetadataLength);
        f.readFully(footerBytesBuffer);
        LOG.debug("Finished to read all footer bytes.");
        footerBytesBuffer.flip();
        ByteBufferInputStream footerBytesStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{footerBytesBuffer});
        if (!encryptedFooterMode) {
            return converter.readParquetMetadata((InputStream)footerBytesStream, options.getMetadataFilter(), fileDecryptor, false, fileMetadataLength);
        }
        if (null == fileDecryptor) {
            throw new ParquetCryptoRuntimeException("Trying to read file with encrypted footer. No keys available");
        }
        FileCryptoMetaData fileCryptoMetaData = Util.readFileCryptoMetaData((InputStream)footerBytesStream);
        fileDecryptor.setFileCryptoMetaData(fileCryptoMetaData.getEncryption_algorithm(), true, fileCryptoMetaData.getKey_metadata());
        return converter.readParquetMetadata((InputStream)footerBytesStream, options.getMetadataFilter(), fileDecryptor, true, 0);
    }

    @Deprecated
    public static ParquetFileReader open(Configuration conf, Path file) throws IOException {
        return new ParquetFileReader(HadoopInputFile.fromPath(file, conf), HadoopReadOptions.builder(conf, file).build());
    }

    @Deprecated
    public static ParquetFileReader open(Configuration conf, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        return ParquetFileReader.open(HadoopInputFile.fromPath(file, conf), HadoopReadOptions.builder(conf, file).withMetadataFilter(filter).build());
    }

    @Deprecated
    public static ParquetFileReader open(Configuration conf, Path file, ParquetMetadata footer) throws IOException {
        return new ParquetFileReader(conf, file, footer);
    }

    public static ParquetFileReader open(InputFile file) throws IOException {
        return new ParquetFileReader(file, ParquetReadOptions.builder().build());
    }

    public static ParquetFileReader open(InputFile file, ParquetReadOptions options) throws IOException {
        return new ParquetFileReader(file, options);
    }

    @Deprecated
    public ParquetFileReader(Configuration configuration, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this(configuration, null, filePath, blocks, columns);
    }

    @Deprecated
    public ParquetFileReader(Configuration configuration, FileMetaData fileMetaData, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this.converter = new ParquetMetadataConverter(configuration);
        this.file = HadoopInputFile.fromPath(filePath, configuration);
        this.fileMetaData = fileMetaData;
        this.f = this.file.newStream();
        this.fileDecryptor = fileMetaData.getFileDecryptor();
        this.options = null == this.fileDecryptor ? HadoopReadOptions.builder(configuration).build() : HadoopReadOptions.builder(configuration).withDecryption(this.fileDecryptor.getDecryptionProperties()).build();
        this.blocks = this.filterRowGroups(blocks);
        this.blockIndexStores = ParquetFileReader.listWithNulls(this.blocks.size());
        this.blockRowRanges = ParquetFileReader.listWithNulls(this.blocks.size());
        for (ColumnDescriptor col : columns) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
        this.crc = this.options.usePageChecksumVerification() ? new CRC32() : null;
    }

    @Deprecated
    public ParquetFileReader(Configuration conf, Path file, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        this(HadoopInputFile.fromPath(file, conf), HadoopReadOptions.builder(conf, file).withMetadataFilter(filter).build());
    }

    @Deprecated
    public ParquetFileReader(Configuration conf, Path file, ParquetMetadata footer) throws IOException {
        this.converter = new ParquetMetadataConverter(conf);
        this.file = HadoopInputFile.fromPath(file, conf);
        this.f = this.file.newStream();
        this.fileMetaData = footer.getFileMetaData();
        this.fileDecryptor = this.fileMetaData.getFileDecryptor();
        this.options = null == this.fileDecryptor ? HadoopReadOptions.builder(conf).build() : HadoopReadOptions.builder(conf).withDecryption(this.fileDecryptor.getDecryptionProperties()).build();
        this.footer = footer;
        this.blocks = this.filterRowGroups(footer.getBlocks());
        this.blockIndexStores = ParquetFileReader.listWithNulls(this.blocks.size());
        this.blockRowRanges = ParquetFileReader.listWithNulls(this.blocks.size());
        for (ColumnDescriptor col : footer.getFileMetaData().getSchema().getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
        this.crc = this.options.usePageChecksumVerification() ? new CRC32() : null;
    }

    public ParquetFileReader(InputFile file, ParquetReadOptions options) throws IOException {
        this.converter = new ParquetMetadataConverter(options);
        this.file = file;
        this.f = file.newStream();
        this.options = options;
        try {
            this.footer = ParquetFileReader.readFooter(file, options, this.f, this.converter);
        }
        catch (Exception e) {
            this.f.close();
            throw e;
        }
        this.fileMetaData = this.footer.getFileMetaData();
        this.fileDecryptor = this.fileMetaData.getFileDecryptor();
        if (null != this.fileDecryptor && this.fileDecryptor.plaintextFile()) {
            this.fileDecryptor = null;
        }
        this.blocks = this.filterRowGroups(this.footer.getBlocks());
        this.blockIndexStores = ParquetFileReader.listWithNulls(this.blocks.size());
        this.blockRowRanges = ParquetFileReader.listWithNulls(this.blocks.size());
        for (ColumnDescriptor col : this.footer.getFileMetaData().getSchema().getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
        this.crc = options.usePageChecksumVerification() ? new CRC32() : null;
    }

    private static <T> List<T> listWithNulls(int size) {
        return Stream.generate(() -> null).limit(size).collect(Collectors.toCollection(ArrayList::new));
    }

    public ParquetMetadata getFooter() {
        if (this.footer == null) {
            try {
                this.footer = ParquetFileReader.readFooter(this.file, this.options, this.f, this.converter);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Unable to read file footer", (Throwable)e);
            }
        }
        return this.footer;
    }

    public FileMetaData getFileMetaData() {
        if (this.fileMetaData != null) {
            return this.fileMetaData;
        }
        return this.getFooter().getFileMetaData();
    }

    public long getRecordCount() {
        long total = 0L;
        for (BlockMetaData block : this.blocks) {
            total += block.getRowCount();
        }
        return total;
    }

    public long getFilteredRecordCount() {
        if (!this.options.useColumnIndexFilter() || !FilterCompat.isFilteringRequired((FilterCompat.Filter)this.options.getRecordFilter())) {
            return this.getRecordCount();
        }
        long total = 0L;
        int n = this.blocks.size();
        for (int i = 0; i < n; ++i) {
            total += this.getRowRanges(i).rowCount();
        }
        return total;
    }

    @Deprecated
    public Path getPath() {
        return new Path(this.file.toString());
    }

    public String getFile() {
        return this.file.toString();
    }

    private List<BlockMetaData> filterRowGroups(List<BlockMetaData> blocks) throws IOException {
        FilterCompat.Filter recordFilter = this.options.getRecordFilter();
        if (FilterCompat.isFilteringRequired((FilterCompat.Filter)recordFilter)) {
            ArrayList<RowGroupFilter.FilterLevel> levels = new ArrayList<RowGroupFilter.FilterLevel>();
            if (this.options.useStatsFilter()) {
                levels.add(RowGroupFilter.FilterLevel.STATISTICS);
            }
            if (this.options.useDictionaryFilter()) {
                levels.add(RowGroupFilter.FilterLevel.DICTIONARY);
            }
            if (this.options.useBloomFilter()) {
                levels.add(RowGroupFilter.FilterLevel.BLOOMFILTER);
            }
            return RowGroupFilter.filterRowGroups(levels, recordFilter, blocks, this);
        }
        return blocks;
    }

    public List<BlockMetaData> getRowGroups() {
        return this.blocks;
    }

    public void setRequestedSchema(MessageType projection) {
        this.paths.clear();
        for (ColumnDescriptor col : projection.getColumns()) {
            this.paths.put(ColumnPath.get((String[])col.getPath()), col);
        }
    }

    public void appendTo(ParquetFileWriter writer) throws IOException {
        writer.appendRowGroups(this.f, this.blocks, true);
    }

    public PageReadStore readNextRowGroup() throws IOException {
        if (this.currentBlock == this.blocks.size()) {
            return null;
        }
        BlockMetaData block = this.blocks.get(this.currentBlock);
        if (block.getRowCount() == 0L) {
            throw new RuntimeException("Illegal row group of 0 rows");
        }
        this.currentRowGroup = new ColumnChunkPageReadStore(block.getRowCount());
        ArrayList<ConsecutivePartList> allParts = new ArrayList<ConsecutivePartList>();
        ConsecutivePartList currentParts = null;
        for (ColumnChunkMetaData mc : block.getColumns()) {
            ColumnPath pathKey = mc.getPath();
            ColumnDescriptor columnDescriptor = this.paths.get(pathKey);
            if (columnDescriptor == null) continue;
            BenchmarkCounter.incrementTotalBytes(mc.getTotalSize());
            long startingPos = mc.getStartingPos();
            if (currentParts == null || currentParts.endPos() != startingPos) {
                currentParts = new ConsecutivePartList(startingPos);
                allParts.add(currentParts);
            }
            currentParts.addChunk(new ChunkDescriptor(columnDescriptor, mc, startingPos, (int)mc.getTotalSize()));
        }
        ChunkListBuilder builder = new ChunkListBuilder();
        for (ConsecutivePartList consecutiveChunks : allParts) {
            consecutiveChunks.readAll(this.f, builder);
        }
        for (Chunk chunk : builder.build()) {
            this.readChunkPages(chunk, block);
        }
        if (this.nextDictionaryReader != null) {
            this.nextDictionaryReader.setRowGroup(this.currentRowGroup);
        }
        this.advanceToNextBlock();
        return this.currentRowGroup;
    }

    public PageReadStore readNextFilteredRowGroup() throws IOException {
        if (this.currentBlock == this.blocks.size()) {
            return null;
        }
        if (!this.options.useColumnIndexFilter() || !FilterCompat.isFilteringRequired((FilterCompat.Filter)this.options.getRecordFilter())) {
            return this.readNextRowGroup();
        }
        BlockMetaData block = this.blocks.get(this.currentBlock);
        if (block.getRowCount() == 0L) {
            throw new RuntimeException("Illegal row group of 0 rows");
        }
        ColumnIndexStore ciStore = this.getColumnIndexStore(this.currentBlock);
        RowRanges rowRanges = this.getRowRanges(this.currentBlock);
        long rowCount = rowRanges.rowCount();
        if (rowCount == 0L) {
            this.advanceToNextBlock();
            return this.readNextFilteredRowGroup();
        }
        if (rowCount == block.getRowCount()) {
            return this.readNextRowGroup();
        }
        this.currentRowGroup = new ColumnChunkPageReadStore(rowRanges);
        ChunkListBuilder builder = new ChunkListBuilder();
        ArrayList<ConsecutivePartList> allParts = new ArrayList<ConsecutivePartList>();
        ConsecutivePartList currentParts = null;
        for (ColumnChunkMetaData mc : block.getColumns()) {
            ColumnPath pathKey = mc.getPath();
            ColumnDescriptor columnDescriptor = this.paths.get(pathKey);
            if (columnDescriptor == null) continue;
            OffsetIndex offsetIndex = ciStore.getOffsetIndex(mc.getPath());
            OffsetIndex filteredOffsetIndex = ColumnIndexFilterUtils.filterOffsetIndex(offsetIndex, rowRanges, block.getRowCount());
            for (ColumnIndexFilterUtils.OffsetRange range : ColumnIndexFilterUtils.calculateOffsetRanges(filteredOffsetIndex, mc, offsetIndex.getOffset(0))) {
                BenchmarkCounter.incrementTotalBytes(range.getLength());
                long startingPos = range.getOffset();
                if (currentParts == null || currentParts.endPos() != startingPos) {
                    currentParts = new ConsecutivePartList(startingPos);
                    allParts.add(currentParts);
                }
                ChunkDescriptor chunkDescriptor = new ChunkDescriptor(columnDescriptor, mc, startingPos, (int)range.getLength());
                currentParts.addChunk(chunkDescriptor);
                builder.setOffsetIndex(chunkDescriptor, filteredOffsetIndex);
            }
        }
        for (ConsecutivePartList consecutiveChunks : allParts) {
            consecutiveChunks.readAll(this.f, builder);
        }
        for (Chunk chunk : builder.build()) {
            this.readChunkPages(chunk, block);
        }
        if (this.nextDictionaryReader != null) {
            this.nextDictionaryReader.setRowGroup(this.currentRowGroup);
        }
        this.advanceToNextBlock();
        return this.currentRowGroup;
    }

    private void readChunkPages(Chunk chunk, BlockMetaData block) throws IOException {
        if (null == this.fileDecryptor || this.fileDecryptor.plaintextFile()) {
            this.currentRowGroup.addColumn(chunk.descriptor.col, chunk.readAllPages());
            return;
        }
        ColumnPath columnPath = ColumnPath.get((String[])chunk.descriptor.col.getPath());
        InternalColumnDecryptionSetup columnDecryptionSetup = this.fileDecryptor.getColumnSetup(columnPath);
        if (!columnDecryptionSetup.isEncrypted()) {
            this.currentRowGroup.addColumn(chunk.descriptor.col, chunk.readAllPages());
        } else {
            this.currentRowGroup.addColumn(chunk.descriptor.col, chunk.readAllPages(columnDecryptionSetup.getMetaDataDecryptor(), columnDecryptionSetup.getDataDecryptor(), this.fileDecryptor.getFileAAD(), block.getOrdinal(), columnDecryptionSetup.getOrdinal()));
        }
    }

    private ColumnIndexStore getColumnIndexStore(int blockIndex) {
        ColumnIndexStore ciStore = this.blockIndexStores.get(blockIndex);
        if (ciStore == null) {
            ciStore = ColumnIndexStoreImpl.create(this, this.blocks.get(blockIndex), this.paths.keySet());
            this.blockIndexStores.set(blockIndex, ciStore);
        }
        return ciStore;
    }

    private RowRanges getRowRanges(int blockIndex) {
        assert (FilterCompat.isFilteringRequired((FilterCompat.Filter)this.options.getRecordFilter())) : "Should not be invoked if filter is null or NOOP";
        RowRanges rowRanges = this.blockRowRanges.get(blockIndex);
        if (rowRanges == null) {
            rowRanges = ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)this.options.getRecordFilter(), (ColumnIndexStore)this.getColumnIndexStore(blockIndex), this.paths.keySet(), (long)this.blocks.get(blockIndex).getRowCount());
            this.blockRowRanges.set(blockIndex, rowRanges);
        }
        return rowRanges;
    }

    public boolean skipNextRowGroup() {
        return this.advanceToNextBlock();
    }

    private boolean advanceToNextBlock() {
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        ++this.currentBlock;
        this.nextDictionaryReader = null;
        return true;
    }

    public DictionaryPageReadStore getNextDictionaryReader() {
        if (this.nextDictionaryReader == null && this.currentBlock < this.blocks.size()) {
            this.nextDictionaryReader = this.getDictionaryReader(this.blocks.get(this.currentBlock));
        }
        return this.nextDictionaryReader;
    }

    public DictionaryPageReader getDictionaryReader(BlockMetaData block) {
        return new DictionaryPageReader(this, block);
    }

    DictionaryPage readDictionary(ColumnChunkMetaData meta) throws IOException {
        PageHeader pageHeader;
        if (!meta.hasDictionaryPage()) {
            return null;
        }
        if (this.f.getPos() != meta.getStartingPos()) {
            this.f.seek(meta.getStartingPos());
        }
        boolean encryptedColumn = false;
        InternalColumnDecryptionSetup columnDecryptionSetup = null;
        byte[] dictionaryPageAAD = null;
        BlockCipher.Decryptor pageDecryptor = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(meta.getPath())).isEncrypted()) {
            encryptedColumn = true;
        }
        if (!encryptedColumn) {
            pageHeader = Util.readPageHeader((InputStream)this.f);
        } else {
            byte[] dictionaryPageHeaderAAD = AesCipher.createModuleAAD(this.fileDecryptor.getFileAAD(), ModuleCipherFactory.ModuleType.DictionaryPageHeader, meta.getRowGroupOrdinal(), columnDecryptionSetup.getOrdinal(), -1);
            pageHeader = Util.readPageHeader((InputStream)this.f, (BlockCipher.Decryptor)columnDecryptionSetup.getMetaDataDecryptor(), (byte[])dictionaryPageHeaderAAD);
            dictionaryPageAAD = AesCipher.createModuleAAD(this.fileDecryptor.getFileAAD(), ModuleCipherFactory.ModuleType.DictionaryPage, meta.getRowGroupOrdinal(), columnDecryptionSetup.getOrdinal(), -1);
            pageDecryptor = columnDecryptionSetup.getDataDecryptor();
        }
        if (!pageHeader.isSetDictionary_page_header()) {
            return null;
        }
        DictionaryPage compressedPage = this.readCompressedDictionary(pageHeader, this.f, pageDecryptor, dictionaryPageAAD);
        CompressionCodecFactory.BytesInputDecompressor decompressor = this.options.getCodecFactory().getDecompressor(meta.getCodec());
        return new DictionaryPage(decompressor.decompress(compressedPage.getBytes(), compressedPage.getUncompressedSize()), compressedPage.getDictionarySize(), compressedPage.getEncoding());
    }

    private DictionaryPage readCompressedDictionary(PageHeader pageHeader, SeekableInputStream fin, BlockCipher.Decryptor pageDecryptor, byte[] dictionaryPageAAD) throws IOException {
        DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
        int uncompressedPageSize = pageHeader.getUncompressed_page_size();
        int compressedPageSize = pageHeader.getCompressed_page_size();
        byte[] dictPageBytes = new byte[compressedPageSize];
        fin.readFully(dictPageBytes);
        BytesInput bin = BytesInput.from((byte[])dictPageBytes);
        if (null != pageDecryptor) {
            bin = BytesInput.from((byte[])pageDecryptor.decrypt(bin.toByteArray(), dictionaryPageAAD));
        }
        return new DictionaryPage(bin, uncompressedPageSize, dictHeader.getNum_values(), this.converter.getEncoding(dictHeader.getEncoding()));
    }

    public BloomFilterReader getBloomFilterDataReader(BlockMetaData block) {
        return new BloomFilterReader(this, block);
    }

    public BloomFilter readBloomFilter(ColumnChunkMetaData meta) throws IOException {
        byte[] bitset;
        BloomFilterHeader bloomFilterHeader;
        InternalColumnDecryptionSetup columnDecryptionSetup;
        long bloomFilterOffset = meta.getBloomFilterOffset();
        if (bloomFilterOffset < 0L) {
            return null;
        }
        BlockCipher.Decryptor bloomFilterDecryptor = null;
        byte[] bloomFilterHeaderAAD = null;
        byte[] bloomFilterBitsetAAD = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(meta.getPath())).isEncrypted()) {
            bloomFilterDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            bloomFilterHeaderAAD = AesCipher.createModuleAAD(this.fileDecryptor.getFileAAD(), ModuleCipherFactory.ModuleType.BloomFilterHeader, meta.getRowGroupOrdinal(), columnDecryptionSetup.getOrdinal(), -1);
            bloomFilterBitsetAAD = AesCipher.createModuleAAD(this.fileDecryptor.getFileAAD(), ModuleCipherFactory.ModuleType.BloomFilterBitset, meta.getRowGroupOrdinal(), columnDecryptionSetup.getOrdinal(), -1);
        }
        this.f.seek(bloomFilterOffset);
        try {
            bloomFilterHeader = Util.readBloomFilterHeader((InputStream)this.f, bloomFilterDecryptor, bloomFilterHeaderAAD);
        }
        catch (IOException e) {
            LOG.warn("read no bloom filter");
            return null;
        }
        int numBytes = bloomFilterHeader.getNumBytes();
        if (numBytes <= 0 || numBytes > 0x8000000) {
            LOG.warn("the read bloom filter size is wrong, size is {}", (Object)bloomFilterHeader.getNumBytes());
            return null;
        }
        if (!(bloomFilterHeader.getHash().isSetXXHASH() && bloomFilterHeader.getAlgorithm().isSetBLOCK() && bloomFilterHeader.getCompression().isSetUNCOMPRESSED())) {
            LOG.warn("the read bloom filter is not supported yet,  algorithm = {}, hash = {}, compression = {}", new Object[]{bloomFilterHeader.getAlgorithm(), bloomFilterHeader.getHash(), bloomFilterHeader.getCompression()});
            return null;
        }
        if (null == bloomFilterDecryptor) {
            bitset = new byte[numBytes];
            this.f.readFully(bitset);
        } else {
            bitset = bloomFilterDecryptor.decrypt((InputStream)this.f, bloomFilterBitsetAAD);
            if (bitset.length != numBytes) {
                throw new ParquetCryptoRuntimeException("Wrong length of decrypted bloom filter bitset");
            }
        }
        return new BlockSplitBloomFilter(bitset);
    }

    @InterfaceAudience.Private
    public ColumnIndex readColumnIndex(ColumnChunkMetaData column) throws IOException {
        InternalColumnDecryptionSetup columnDecryptionSetup;
        IndexReference ref = column.getColumnIndexReference();
        if (ref == null) {
            return null;
        }
        this.f.seek(ref.getOffset());
        BlockCipher.Decryptor columnIndexDecryptor = null;
        byte[] columnIndexAAD = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(column.getPath())).isEncrypted()) {
            columnIndexDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            columnIndexAAD = AesCipher.createModuleAAD(this.fileDecryptor.getFileAAD(), ModuleCipherFactory.ModuleType.ColumnIndex, column.getRowGroupOrdinal(), columnDecryptionSetup.getOrdinal(), -1);
        }
        return ParquetMetadataConverter.fromParquetColumnIndex(column.getPrimitiveType(), Util.readColumnIndex((InputStream)this.f, columnIndexDecryptor, columnIndexAAD));
    }

    @InterfaceAudience.Private
    public OffsetIndex readOffsetIndex(ColumnChunkMetaData column) throws IOException {
        InternalColumnDecryptionSetup columnDecryptionSetup;
        IndexReference ref = column.getOffsetIndexReference();
        if (ref == null) {
            return null;
        }
        this.f.seek(ref.getOffset());
        BlockCipher.Decryptor offsetIndexDecryptor = null;
        byte[] offsetIndexAAD = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(column.getPath())).isEncrypted()) {
            offsetIndexDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            offsetIndexAAD = AesCipher.createModuleAAD(this.fileDecryptor.getFileAAD(), ModuleCipherFactory.ModuleType.OffsetIndex, column.getRowGroupOrdinal(), columnDecryptionSetup.getOrdinal(), -1);
        }
        return ParquetMetadataConverter.fromParquetOffsetIndex(Util.readOffsetIndex((InputStream)this.f, offsetIndexDecryptor, offsetIndexAAD));
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        finally {
            this.options.getCodecFactory().release();
        }
    }

    private class ConsecutivePartList {
        private final long offset;
        private int length;
        private final List<ChunkDescriptor> chunks = new ArrayList<ChunkDescriptor>();

        ConsecutivePartList(long offset) {
            this.offset = offset;
        }

        public void addChunk(ChunkDescriptor descriptor) {
            this.chunks.add(descriptor);
            this.length += descriptor.size;
        }

        public void readAll(SeekableInputStream f, ChunkListBuilder builder) throws IOException {
            ArrayList result = new ArrayList(this.chunks.size());
            f.seek(this.offset);
            int fullAllocations = this.length / ParquetFileReader.this.options.getMaxAllocationSize();
            int lastAllocationSize = this.length % ParquetFileReader.this.options.getMaxAllocationSize();
            int numAllocations = fullAllocations + (lastAllocationSize > 0 ? 1 : 0);
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(numAllocations);
            for (int i = 0; i < fullAllocations; ++i) {
                buffers.add(ParquetFileReader.this.options.getAllocator().allocate(ParquetFileReader.this.options.getMaxAllocationSize()));
            }
            if (lastAllocationSize > 0) {
                buffers.add(ParquetFileReader.this.options.getAllocator().allocate(lastAllocationSize));
            }
            for (ByteBuffer buffer : buffers) {
                f.readFully(buffer);
                buffer.flip();
            }
            BenchmarkCounter.incrementBytesRead(this.length);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap(buffers);
            for (int i = 0; i < this.chunks.size(); ++i) {
                ChunkDescriptor descriptor = this.chunks.get(i);
                builder.add(descriptor, stream.sliceBuffers((long)descriptor.size), f);
            }
        }

        public long endPos() {
            return this.offset + (long)this.length;
        }
    }

    private static class ChunkDescriptor {
        private final ColumnDescriptor col;
        private final ColumnChunkMetaData metadata;
        private final long fileOffset;
        private final int size;

        private ChunkDescriptor(ColumnDescriptor col, ColumnChunkMetaData metadata, long fileOffset, int size) {
            this.col = col;
            this.metadata = metadata;
            this.fileOffset = fileOffset;
            this.size = size;
        }

        public int hashCode() {
            return this.col.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ChunkDescriptor) {
                return this.col.equals((Object)((ChunkDescriptor)obj).col);
            }
            return false;
        }
    }

    private class WorkaroundChunk
    extends Chunk {
        private final SeekableInputStream f;

        private WorkaroundChunk(ChunkDescriptor descriptor, List<ByteBuffer> buffers, SeekableInputStream f, OffsetIndex offsetIndex) {
            super(descriptor, buffers, offsetIndex);
            this.f = f;
        }

        @Override
        protected PageHeader readPageHeader() throws IOException {
            PageHeader pageHeader;
            this.stream.mark(8192);
            try {
                pageHeader = Util.readPageHeader((InputStream)this.stream);
            }
            catch (IOException e) {
                this.stream.reset();
                LOG.info("completing the column chunk to read the page header");
                pageHeader = Util.readPageHeader((InputStream)new SequenceInputStream((InputStream)this.stream, (InputStream)this.f));
            }
            return pageHeader;
        }

        @Override
        public BytesInput readAsBytesInput(int size) throws IOException {
            int available = this.stream.available();
            if (size > available) {
                int missingBytes = size - available;
                LOG.info("completed the column chunk with {} bytes", (Object)missingBytes);
                ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
                buffers.addAll(this.stream.sliceBuffers((long)available));
                ByteBuffer lastBuffer = ByteBuffer.allocate(missingBytes);
                this.f.readFully(lastBuffer);
                buffers.add(lastBuffer);
                return BytesInput.from(buffers);
            }
            return super.readAsBytesInput(size);
        }
    }

    private class Chunk {
        protected final ChunkDescriptor descriptor;
        protected final ByteBufferInputStream stream;
        final OffsetIndex offsetIndex;

        public Chunk(ChunkDescriptor descriptor, List<ByteBuffer> buffers, OffsetIndex offsetIndex) {
            this.descriptor = descriptor;
            this.stream = ByteBufferInputStream.wrap(buffers);
            this.offsetIndex = offsetIndex;
        }

        protected PageHeader readPageHeader() throws IOException {
            return this.readPageHeader(null, null);
        }

        protected PageHeader readPageHeader(BlockCipher.Decryptor blockDecryptor, byte[] pageHeaderAAD) throws IOException {
            return Util.readPageHeader((InputStream)this.stream, (BlockCipher.Decryptor)blockDecryptor, (byte[])pageHeaderAAD);
        }

        private void verifyCrc(int referenceCrc, byte[] bytes, String exceptionMsg) {
            ParquetFileReader.this.crc.reset();
            ParquetFileReader.this.crc.update(bytes);
            if (ParquetFileReader.this.crc.getValue() != ((long)referenceCrc & 0xFFFFFFFFL)) {
                throw new ParquetDecodingException(exceptionMsg);
            }
        }

        public ColumnChunkPageReadStore.ColumnChunkPageReader readAllPages() throws IOException {
            return this.readAllPages(null, null, null, -1, -1);
        }

        public ColumnChunkPageReadStore.ColumnChunkPageReader readAllPages(BlockCipher.Decryptor headerBlockDecryptor, BlockCipher.Decryptor pageBlockDecryptor, byte[] aadPrefix, int rowGroupOrdinal, int columnOrdinal) throws IOException {
            ArrayList<DataPage> pagesInChunk = new ArrayList<DataPage>();
            DictionaryPage dictionaryPage = null;
            PrimitiveType type = ParquetFileReader.this.getFileMetaData().getSchema().getType(this.descriptor.col.getPath()).asPrimitiveType();
            long valuesCountReadSoFar = 0L;
            int dataPageCountReadSoFar = 0;
            byte[] dataPageHeaderAAD = null;
            if (null != headerBlockDecryptor) {
                dataPageHeaderAAD = AesCipher.createModuleAAD(aadPrefix, ModuleCipherFactory.ModuleType.DataPageHeader, rowGroupOrdinal, columnOrdinal, this.getPageOrdinal(dataPageCountReadSoFar));
            }
            block5: while (this.hasMorePages(valuesCountReadSoFar, dataPageCountReadSoFar)) {
                byte[] pageHeaderAAD = dataPageHeaderAAD;
                if (null != headerBlockDecryptor) {
                    if (null == dictionaryPage && this.descriptor.metadata.hasDictionaryPage()) {
                        pageHeaderAAD = AesCipher.createModuleAAD(aadPrefix, ModuleCipherFactory.ModuleType.DictionaryPageHeader, rowGroupOrdinal, columnOrdinal, -1);
                    } else {
                        int pageOrdinal = this.getPageOrdinal(dataPageCountReadSoFar);
                        AesCipher.quickUpdatePageAAD(dataPageHeaderAAD, pageOrdinal);
                    }
                }
                PageHeader pageHeader = this.readPageHeader(headerBlockDecryptor, pageHeaderAAD);
                int uncompressedPageSize = pageHeader.getUncompressed_page_size();
                int compressedPageSize = pageHeader.getCompressed_page_size();
                switch (pageHeader.type) {
                    case DICTIONARY_PAGE: {
                        if (dictionaryPage != null) {
                            throw new ParquetDecodingException("more than one dictionary page in column " + this.descriptor.col);
                        }
                        BytesInput pageBytes = this.readAsBytesInput(compressedPageSize);
                        if (ParquetFileReader.this.options.usePageChecksumVerification() && pageHeader.isSetCrc()) {
                            this.verifyCrc(pageHeader.getCrc(), pageBytes.toByteArray(), "could not verify dictionary page integrity, CRC checksum verification failed");
                        }
                        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
                        dictionaryPage = new DictionaryPage(pageBytes, uncompressedPageSize, dicHeader.getNum_values(), ParquetFileReader.this.converter.getEncoding(dicHeader.getEncoding()));
                        if (!pageHeader.isSetCrc()) continue block5;
                        dictionaryPage.setCrc(pageHeader.getCrc());
                        continue block5;
                    }
                    case DATA_PAGE: {
                        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
                        BytesInput pageBytes = this.readAsBytesInput(compressedPageSize);
                        if (ParquetFileReader.this.options.usePageChecksumVerification() && pageHeader.isSetCrc()) {
                            this.verifyCrc(pageHeader.getCrc(), pageBytes.toByteArray(), "could not verify page integrity, CRC checksum verification failed");
                        }
                        DataPageV1 dataPageV1 = new DataPageV1(pageBytes, dataHeaderV1.getNum_values(), uncompressedPageSize, ParquetFileReader.this.converter.fromParquetStatistics(ParquetFileReader.this.getFileMetaData().getCreatedBy(), dataHeaderV1.getStatistics(), type), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getRepetition_level_encoding()), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getDefinition_level_encoding()), ParquetFileReader.this.converter.getEncoding(dataHeaderV1.getEncoding()));
                        if (pageHeader.isSetCrc()) {
                            dataPageV1.setCrc(pageHeader.getCrc());
                        }
                        pagesInChunk.add((DataPage)dataPageV1);
                        valuesCountReadSoFar += (long)dataHeaderV1.getNum_values();
                        ++dataPageCountReadSoFar;
                        continue block5;
                    }
                    case DATA_PAGE_V2: {
                        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
                        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
                        pagesInChunk.add((DataPage)new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.readAsBytesInput(dataHeaderV2.getRepetition_levels_byte_length()), this.readAsBytesInput(dataHeaderV2.getDefinition_levels_byte_length()), ParquetFileReader.this.converter.getEncoding(dataHeaderV2.getEncoding()), this.readAsBytesInput(dataSize), uncompressedPageSize, ParquetFileReader.this.converter.fromParquetStatistics(ParquetFileReader.this.getFileMetaData().getCreatedBy(), dataHeaderV2.getStatistics(), type), dataHeaderV2.isIs_compressed()));
                        valuesCountReadSoFar += (long)dataHeaderV2.getNum_values();
                        ++dataPageCountReadSoFar;
                        continue block5;
                    }
                }
                LOG.debug("skipping page of type {} of size {}", (Object)pageHeader.getType(), (Object)compressedPageSize);
                this.stream.skipFully((long)compressedPageSize);
            }
            if (this.offsetIndex == null && valuesCountReadSoFar != this.descriptor.metadata.getValueCount()) {
                throw new IOException("Expected " + this.descriptor.metadata.getValueCount() + " values in column chunk at " + ParquetFileReader.this.getPath() + " offset " + this.descriptor.metadata.getFirstDataPageOffset() + " but got " + valuesCountReadSoFar + " values instead over " + pagesInChunk.size() + " pages ending at file offset " + (this.descriptor.fileOffset + this.stream.position()));
            }
            CompressionCodecFactory.BytesInputDecompressor decompressor = ParquetFileReader.this.options.getCodecFactory().getDecompressor(this.descriptor.metadata.getCodec());
            return new ColumnChunkPageReadStore.ColumnChunkPageReader(decompressor, pagesInChunk, dictionaryPage, this.offsetIndex, ((BlockMetaData)ParquetFileReader.this.blocks.get(ParquetFileReader.this.currentBlock)).getRowCount(), pageBlockDecryptor, aadPrefix, rowGroupOrdinal, columnOrdinal);
        }

        private boolean hasMorePages(long valuesCountReadSoFar, int dataPageCountReadSoFar) {
            return this.offsetIndex == null ? valuesCountReadSoFar < this.descriptor.metadata.getValueCount() : dataPageCountReadSoFar < this.offsetIndex.getPageCount();
        }

        private int getPageOrdinal(int dataPageCountReadSoFar) {
            if (null == this.offsetIndex) {
                return dataPageCountReadSoFar;
            }
            return this.offsetIndex.getPageOrdinal(dataPageCountReadSoFar);
        }

        public BytesInput readAsBytesInput(int size) throws IOException {
            return BytesInput.from((List)this.stream.sliceBuffers((long)size));
        }
    }

    private class ChunkListBuilder {
        private final Map<ChunkDescriptor, ChunkData> map = new HashMap<ChunkDescriptor, ChunkData>();
        private ChunkDescriptor lastDescriptor;
        private SeekableInputStream f;

        private ChunkListBuilder() {
        }

        void add(ChunkDescriptor descriptor, List<ByteBuffer> buffers, SeekableInputStream f) {
            ChunkData data = this.map.get(descriptor);
            if (data == null) {
                data = new ChunkData();
                this.map.put(descriptor, data);
            }
            data.buffers.addAll(buffers);
            this.lastDescriptor = descriptor;
            this.f = f;
        }

        void setOffsetIndex(ChunkDescriptor descriptor, OffsetIndex offsetIndex) {
            ChunkData data = this.map.get(descriptor);
            if (data == null) {
                data = new ChunkData();
                this.map.put(descriptor, data);
            }
            data.offsetIndex = offsetIndex;
        }

        List<Chunk> build() {
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            for (Map.Entry<ChunkDescriptor, ChunkData> entry : this.map.entrySet()) {
                ChunkDescriptor descriptor = entry.getKey();
                ChunkData data = entry.getValue();
                if (descriptor.equals(this.lastDescriptor)) {
                    chunks.add(new WorkaroundChunk(this.lastDescriptor, data.buffers, this.f, data.offsetIndex));
                    continue;
                }
                chunks.add(new Chunk(descriptor, data.buffers, data.offsetIndex));
            }
            return chunks;
        }

        private class ChunkData {
            final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            OffsetIndex offsetIndex;

            private ChunkData() {
            }
        }
    }
}

