/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.Serializable;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexDataflowHelper
implements IIndexDataflowHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INCServiceContext ctx;
    private final IResourceLifecycleManager<IIndex> lcManager;
    private final ILocalResourceRepository localResourceRepository;
    private final FileReference resourceRef;
    private IIndex index;

    public IndexDataflowHelper(INCServiceContext ctx, IStorageManager storageMgr, FileReference resourceRef) throws HyracksDataException {
        this.ctx = ctx;
        this.lcManager = storageMgr.getLifecycleManager(ctx);
        this.localResourceRepository = storageMgr.getLocalResourceRepository(ctx);
        this.resourceRef = resourceRef;
    }

    @Override
    public IIndex getIndexInstance() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.index = (IIndex)this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index == null) {
                LocalResource lr = this.readIndex();
                this.lcManager.register(lr.getPath(), (Object)this.index);
            }
            this.lcManager.open(this.resourceRef.getRelativePath());
        }
    }

    private LocalResource readIndex() throws HyracksDataException {
        LocalResource lr = this.getResource();
        if (lr == null) {
            LOGGER.error("index {} does not exist", (Object)this.resourceRef.getRelativePath());
            throw HyracksDataException.create((ErrorCode)ErrorCode.INDEX_DOES_NOT_EXIST, (Serializable[])new Serializable[0]);
        }
        IResource resource = lr.getResource();
        this.index = resource.createInstance(this.ctx);
        return lr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.lcManager.close(this.resourceRef.getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws HyracksDataException {
        LOGGER.log(Level.INFO, "Dropping index " + this.resourceRef.getRelativePath() + " on node " + this.ctx.getNodeId());
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.index = (IIndex)this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index != null) {
                this.lcManager.unregister(this.resourceRef.getRelativePath());
            } else {
                this.readIndex();
            }
            if (this.getResourceId() != -1L) {
                this.localResourceRepository.delete(this.resourceRef.getRelativePath());
            }
            this.index.destroy();
        }
    }

    private long getResourceId() throws HyracksDataException {
        LocalResource lr = this.localResourceRepository.get(this.resourceRef.getRelativePath());
        return lr == null ? -1L : lr.getId();
    }

    @Override
    public LocalResource getResource() throws HyracksDataException {
        return this.localResourceRepository.get(this.resourceRef.getRelativePath());
    }
}

