/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class LibraryDescriptor
implements IJsonSerializable {
    private static final long serialVersionUID = 3L;
    private static final String FIELD_LANGUAGE = "lang";
    public static final String FIELD_HASH = "hash_md5";
    private final ExternalFunctionLanguage lang;
    private final String hash;

    public LibraryDescriptor(ExternalFunctionLanguage language, String hash) {
        this.lang = language;
        this.hash = hash;
    }

    public ExternalFunctionLanguage getLanguage() {
        return this.lang;
    }

    public String getHash() {
        return this.hash;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) {
        ObjectNode jsonNode = registry.getClassIdentifier(LibraryDescriptor.class, 3L);
        jsonNode.put(FIELD_LANGUAGE, this.lang.name());
        jsonNode.put(FIELD_HASH, this.hash);
        return jsonNode;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        String langText = json.get(FIELD_LANGUAGE).asText();
        ExternalFunctionLanguage lang = ExternalFunctionLanguage.valueOf(langText);
        String hash = json.get(FIELD_HASH).asText();
        return new LibraryDescriptor(lang, hash);
    }
}

