/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.aggregators;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;

public class CountFieldAggregatorFactory
implements IFieldAggregateDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final boolean useObjectState;

    public CountFieldAggregatorFactory(boolean useObjectState) {
        this.useObjectState = useObjectState;
    }

    @Override
    public IFieldAggregateDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        return new IFieldAggregateDescriptor(){

            @Override
            public void reset() {
            }

            @Override
            public void outputPartialResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count = !CountFieldAggregatorFactory.this.useObjectState ? IntegerPointable.getInteger((byte[])data, (int)offset) : (Integer)state.state;
                try {
                    fieldOutput.writeInt(count);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void outputFinalResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count = !CountFieldAggregatorFactory.this.useObjectState ? IntegerPointable.getInteger((byte[])data, (int)offset) : (Integer)state.state;
                try {
                    fieldOutput.writeInt(count);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void init(IFrameTupleAccessor accessor, int tIndex, DataOutput fieldOutput, AggregateState state) throws HyracksDataException {
                int count = 1;
                if (!CountFieldAggregatorFactory.this.useObjectState) {
                    try {
                        fieldOutput.writeInt(count);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException("I/O exception when initializing the aggregator.");
                    }
                } else {
                    state.state = count;
                }
            }

            @Override
            public boolean needsObjectState() {
                return CountFieldAggregatorFactory.this.useObjectState;
            }

            @Override
            public boolean needsBinaryState() {
                return !CountFieldAggregatorFactory.this.useObjectState;
            }

            @Override
            public AggregateState createState() {
                return new AggregateState(new Integer(0));
            }

            @Override
            public void close() {
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count = 1;
                if (!CountFieldAggregatorFactory.this.useObjectState) {
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    buf.putInt(offset, count += buf.getInt(offset));
                } else {
                    state.state = count += ((Integer)state.state).intValue();
                }
            }
        };
    }
}

