/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.storage.blob.implementation.AppendBlobsImpl;
import com.azure.storage.blob.implementation.BlobsImpl;
import com.azure.storage.blob.implementation.BlockBlobsImpl;
import com.azure.storage.blob.implementation.ContainersImpl;
import com.azure.storage.blob.implementation.DirectorysImpl;
import com.azure.storage.blob.implementation.PageBlobsImpl;
import com.azure.storage.blob.implementation.ServicesImpl;
import com.azure.storage.blob.models.PathRenameMode;

public final class AzureBlobStorageImpl {
    private String url;
    private String version;
    private PathRenameMode pathRenameMode;
    private HttpPipeline httpPipeline;
    private ServicesImpl services;
    private ContainersImpl containers;
    private DirectorysImpl directorys;
    private BlobsImpl blobs;
    private PageBlobsImpl pageBlobs;
    private AppendBlobsImpl appendBlobs;
    private BlockBlobsImpl blockBlobs;

    public String getUrl() {
        return this.url;
    }

    AzureBlobStorageImpl setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    AzureBlobStorageImpl setVersion(String version) {
        this.version = version;
        return this;
    }

    public PathRenameMode getPathRenameMode() {
        return this.pathRenameMode;
    }

    AzureBlobStorageImpl setPathRenameMode(PathRenameMode pathRenameMode) {
        this.pathRenameMode = pathRenameMode;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public ServicesImpl services() {
        return this.services;
    }

    public ContainersImpl containers() {
        return this.containers;
    }

    public DirectorysImpl directorys() {
        return this.directorys;
    }

    public BlobsImpl blobs() {
        return this.blobs;
    }

    public PageBlobsImpl pageBlobs() {
        return this.pageBlobs;
    }

    public AppendBlobsImpl appendBlobs() {
        return this.appendBlobs;
    }

    public BlockBlobsImpl blockBlobs() {
        return this.blockBlobs;
    }

    public AzureBlobStorageImpl() {
        new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
    }

    public AzureBlobStorageImpl(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        this.services = new ServicesImpl(this);
        this.containers = new ContainersImpl(this);
        this.directorys = new DirectorysImpl(this);
        this.blobs = new BlobsImpl(this);
        this.pageBlobs = new PageBlobsImpl(this);
        this.appendBlobs = new AppendBlobsImpl(this);
        this.blockBlobs = new BlockBlobsImpl(this);
    }
}

