/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.web.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compass.core.support.search.CompassSearchCommand;
import org.compass.core.support.search.CompassSearchHelper;
import org.compass.core.support.search.CompassSearchResults;
import org.compass.spring.web.mvc.AbstractCompassCommandController;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class CompassSearchController
extends AbstractCompassCommandController {
    private String searchView;
    private String searchResultsView;
    private String searchResultsName = "searchResults";
    private Integer pageSize;
    private CompassSearchHelper searchHelper;

    public CompassSearchController() {
        this.setCommandClass(CompassSearchCommand.class);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.searchView == null) {
            throw new IllegalArgumentException("Must set the searchView property");
        }
        if (this.searchResultsView == null) {
            throw new IllegalArgumentException("Must set the serachResultsView property");
        }
        if (this.searchHelper == null) {
            this.searchHelper = new CompassSearchHelper(this.getCompass(), this.getPageSize());
        }
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        CompassSearchCommand searchCommand = (CompassSearchCommand)command;
        if (!StringUtils.hasText((String)searchCommand.getQuery())) {
            return new ModelAndView(this.getSearchView(), this.getCommandName(), (Object)searchCommand);
        }
        CompassSearchResults searchResults = this.searchHelper.search(searchCommand);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(this.getCommandName(), searchCommand);
        data.put(this.getSearchResultsName(), searchResults);
        return new ModelAndView(this.getSearchResultsView(), data);
    }

    public String getSearchView() {
        return this.searchView;
    }

    public void setSearchView(String searchView) {
        this.searchView = searchView;
    }

    public String getSearchResultsName() {
        return this.searchResultsName;
    }

    public void setSearchResultsName(String searchResultsName) {
        this.searchResultsName = searchResultsName;
    }

    public String getSearchResultsView() {
        return this.searchResultsView;
    }

    public void setSearchResultsView(String resultsView) {
        this.searchResultsView = resultsView;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setSearchHelper(CompassSearchHelper searchHelper) {
        this.searchHelper = searchHelper;
    }
}

