/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.Names;
import org.w3c.dom.Node;

public class CXFUtils {
    public static boolean isLocalCall(Exchange exch) {
        return CXFUtils.isLocalCall(exch.getInMessage());
    }

    public static boolean isLocalCall(Message msg) {
        return msg.getDestination() == null || !(msg.getDestination() instanceof ServletDestination);
    }

    public static String getAction(Message message) {
        Header wsaAction;
        List sa;
        Map headers;
        if (message == null) {
            return null;
        }
        String action = null;
        if (message.get((Object)Message.PROTOCOL_HEADERS) != null && (headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)))) != null && (sa = (List)headers.get("SOAPAction")) != null && sa.size() > 0 && (action = (String)sa.get(0)).startsWith("\"")) {
            action = action.substring(1, action.length() - 1);
        }
        if (action == null && message instanceof SoapMessage && (wsaAction = ((SoapMessage)message).getHeader(Names.WSA_ACTION_QNAME)) != null) {
            action = String.valueOf(wsaAction.getObject());
        }
        if (action == null) {
            Method m = CXFUtils.getMethod(message);
            action = m != null ? m.getName() : null;
        }
        return action;
    }

    public static Method getMethod(Message message) {
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        if (bop == null) {
            return null;
        }
        MethodDispatcher md = (MethodDispatcher)ex.getService().get((Object)MethodDispatcher.class.getName());
        return md.getMethod(bop);
    }

    public static void writeXml(Node n, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "no");
        t.transform(new DOMSource(n), new StreamResult(os));
    }

    public static Message getCurrentMessage() {
        return PhaseInterceptorChain.getCurrentMessage();
    }

    public static AddressingProperties getAddressingProperties() {
        return ContextUtils.retrieveMAPs((Message)CXFUtils.getCurrentMessage(), (boolean)false, (boolean)false);
    }

    public static X509Certificate[] getSSLCerts(SoapMessage message) {
        X509Certificate[] certs = null;
        HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (req != null) {
            certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        }
        return certs;
    }

    public static String getClientIP(SoapMessage message) {
        HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        return req != null ? req.getRemoteAddr() : null;
    }

    public static HttpServletRequest getServletRequest(SoapMessage message) {
        return (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
    }
}

