/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.b5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlCharacters;
import org.xmlpull.infoset.XmlComment;
import org.xmlpull.infoset.XmlContainer;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.XmlPullSerializable;
import org.xmlpull.infoset.impl.XmlDocumentImpl;
import org.xmlpull.infoset.impl.XmlElementWithViewsImpl;
import org.xmlpull.infoset.impl.XmlNamespaceImpl;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullInfosetBuilder
extends XmlInfosetBuilder {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";
    private static final String PROPERTY_XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";
    private boolean readOnly;
    private boolean useComments;
    private boolean usePIs;
    private boolean wrapCharacters;
    private boolean useViews;
    private boolean provideDom2;
    protected XmlPullParserFactory factory;

    public XmlPullInfosetBuilder() throws XmlBuilderException {
        try {
            this.factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            this.factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException ex) {
            throw new XmlBuilderException("could not create XmlPull factory:" + ex, ex);
        }
    }

    public XmlPullInfosetBuilder(XmlPullParserFactory factory) throws XmlBuilderException {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.factory = factory;
        this.factory.setNamespaceAware(true);
    }

    public XmlPullParserFactory getFactory() throws XmlBuilderException {
        return this.factory;
    }

    @Override
    public void setFeature(String featureName, boolean value) throws XmlBuilderException {
        if (featureName.equals("org.xmlpull.infoset.feature.read.only")) {
            this.readOnly = value;
        } else if (featureName.equals("org.xmlpull.infoset.feature.comments")) {
            this.useComments = value;
        } else if (featureName.equals("org.xmlpull.infoset.feature.pis")) {
            this.usePIs = value;
        } else if (featureName.equals("org.xmlpull.infoset.feature.wrap.chars")) {
            this.wrapCharacters = value;
        } else if (featureName.equals("org.xmlpull.infoset.feature.views")) {
            this.useViews = value;
        } else if (featureName.equals("org.xmlpull.infoset.feature.dom2")) {
            this.provideDom2 = value;
        } else {
            throw new XmlBuilderException("feature '" + featureName + "' not recognized");
        }
    }

    @Override
    public XmlDocument newDocument(String version, Boolean standalone, String characterEncoding) {
        return new XmlDocumentImpl(version, standalone, characterEncoding);
    }

    @Override
    public XmlElement newFragment(String elementName) {
        return new XmlElementWithViewsImpl((XmlNamespace)null, elementName);
    }

    @Override
    public XmlElement newFragment(String elementNamespaceName, String elementName) {
        return new XmlElementWithViewsImpl(elementNamespaceName, elementName);
    }

    @Override
    public XmlElement newFragment(XmlNamespace elementNamespace, String elementName) {
        return new XmlElementWithViewsImpl(elementNamespace, elementName);
    }

    @Override
    public XmlNamespace newNamespace(String namespaceName) {
        return new XmlNamespaceImpl(null, namespaceName);
    }

    @Override
    public XmlNamespace newNamespace(String prefix, String namespaceName) {
        return new XmlNamespaceImpl(prefix, namespaceName);
    }

    public XmlDocument parse(XmlPullParser pp) throws XmlBuilderException {
        XmlDocument doc = this.parseDocumentStart(pp);
        XmlElement root = this.parseFragment(pp);
        doc.setDocumentElement(root);
        return doc;
    }

    public Object parseItem(XmlPullParser pp) throws XmlBuilderException {
        try {
            int eventType = pp.getEventType();
            if (eventType == 2) {
                return this.parseStartTag(pp);
            }
            if (eventType == 4) {
                return pp.getText();
            }
            if (eventType == 0) {
                return this.parseDocumentStart(pp);
            }
            throw new XmlBuilderException("currently unsupported event type " + XmlPullParser.TYPES[eventType] + pp.getPositionDescription());
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not parse XML item", e);
        }
    }

    private XmlDocument parseDocumentStart(XmlPullParser pp) {
        XmlDocumentImpl doc = null;
        try {
            if (pp.getEventType() != 0) {
                throw new XmlBuilderException("parser must be positioned on beginning of document and not " + pp.getPositionDescription());
            }
            pp.next();
            String xmlDeclVersion = (String)pp.getProperty(PROPERTY_XMLDECL_VERSION);
            Boolean xmlDeclStandalone = (Boolean)pp.getProperty(PROPERTY_XMLDECL_STANDALONE);
            String characterEncoding = pp.getInputEncoding();
            doc = new XmlDocumentImpl(xmlDeclVersion, xmlDeclStandalone, characterEncoding);
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not parse XML document prolog", e);
        }
        catch (IOException e) {
            throw new XmlBuilderException("could not read XML document prolog", e);
        }
        return doc;
    }

    public XmlElement parseFragment(XmlPullParser pp) throws XmlBuilderException {
        try {
            int depth = pp.getDepth();
            int eventType = pp.getEventType();
            if (eventType != 2) {
                throw new XmlBuilderException("expected parser to be on start tag and not " + XmlPullParser.TYPES[eventType] + pp.getPositionDescription());
            }
            XmlElement curElem = this.parseStartTag(pp);
            while (true) {
                if ((eventType = pp.next()) == 2) {
                    XmlElement child = this.parseStartTag(pp);
                    curElem.addElement(child);
                    curElem = child;
                    continue;
                }
                if (eventType == 3) {
                    XmlContainer parent = curElem.getParent();
                    if (parent == null) {
                        if (pp.getDepth() != depth) {
                            throw new XmlBuilderException("unbalanced input" + pp.getPositionDescription());
                        }
                        return curElem;
                    }
                    curElem = (XmlElement)parent;
                    continue;
                }
                if (eventType == 4) {
                    curElem.addChild(pp.getText());
                    continue;
                }
                if (eventType != 9) continue;
            }
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not build tree from XML", e);
        }
        catch (IOException e) {
            throw new XmlBuilderException("could not read XML tree content", e);
        }
    }

    public XmlElement parseStartTag(XmlPullParser pp) throws XmlBuilderException {
        try {
            int i;
            if (pp.getEventType() != 2) {
                throw new XmlBuilderException("parser must be on START_TAG and not " + pp.getPositionDescription());
            }
            String elNsPrefix = pp.getPrefix();
            XmlNamespaceImpl elementNs = new XmlNamespaceImpl(elNsPrefix, pp.getNamespace());
            XmlElementWithViewsImpl el = new XmlElementWithViewsImpl(elementNs, pp.getName());
            for (i = pp.getNamespaceCount(pp.getDepth() - 1); i < pp.getNamespaceCount(pp.getDepth()); ++i) {
                String prefix = pp.getNamespacePrefix(i);
                el.declareNamespace(prefix == null ? "" : prefix, pp.getNamespaceUri(i));
            }
            for (i = 0; i < pp.getAttributeCount(); ++i) {
                el.setAttribute(pp.getAttributeType(i), pp.getAttributePrefix(i), pp.getAttributeNamespace(i), pp.getAttributeName(i), pp.getAttributeValue(i), !pp.isAttributeDefault(i));
            }
            return el;
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not parse XML start tag", e);
        }
    }

    @Override
    public XmlDocument parseLocation(String locationUrl) throws XmlBuilderException {
        URL url = null;
        try {
            url = new URL(locationUrl);
        }
        catch (MalformedURLException e) {
            throw new XmlBuilderException("could not parse URL " + locationUrl, e);
        }
        try {
            return this.parseInputStream(url.openStream());
        }
        catch (IOException e) {
            throw new XmlBuilderException("could not open connection to URL " + locationUrl, e);
        }
    }

    @Override
    public XmlElement parseFragmentFromInputStream(InputStream is) throws XmlBuilderException {
        XmlPullParser pp = null;
        try {
            pp = this.factory.newPullParser();
            pp.setInput(is, null);
            try {
                pp.nextTag();
            }
            catch (IOException e) {
                throw new XmlBuilderException("IO error when starting to parse input stream", e);
            }
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not start parsing input stream", e);
        }
        return this.parseFragment(pp);
    }

    @Override
    public XmlElement parseFragmentFromInputStream(InputStream is, String encoding) throws XmlBuilderException {
        XmlPullParser pp = null;
        try {
            pp = this.factory.newPullParser();
            pp.setInput(is, encoding);
            try {
                pp.nextTag();
            }
            catch (IOException e) {
                throw new XmlBuilderException("IO error when starting to parse input stream (encoding=" + encoding + ")", e);
            }
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not start parsing input stream (encoding=" + encoding + ")", e);
        }
        return this.parseFragment(pp);
    }

    @Override
    public XmlElement parseFragmentFromReader(Reader reader) throws XmlBuilderException {
        XmlPullParser pp = null;
        try {
            pp = this.factory.newPullParser();
            pp.setInput(reader);
            try {
                pp.nextTag();
            }
            catch (IOException e) {
                throw new XmlBuilderException("IO error when starting to parse from reader", e);
            }
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not start parsing input from reader", e);
        }
        return this.parseFragment(pp);
    }

    @Override
    public XmlDocument parseInputStream(InputStream is) throws XmlBuilderException {
        XmlPullParser pp = null;
        try {
            pp = this.factory.newPullParser();
            pp.setInput(is, null);
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not start parsing input stream", e);
        }
        return this.parse(pp);
    }

    @Override
    public XmlDocument parseInputStream(InputStream is, String encoding) throws XmlBuilderException {
        XmlPullParser pp = null;
        try {
            pp = this.factory.newPullParser();
            pp.setInput(is, encoding);
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not start parsing input stream (encoding=" + encoding + ")", e);
        }
        return this.parse(pp);
    }

    @Override
    public XmlDocument parseReader(Reader reader) throws XmlBuilderException {
        XmlPullParser pp = null;
        try {
            pp = this.factory.newPullParser();
            pp.setInput(reader);
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not start parsing input from reader", e);
        }
        return this.parse(pp);
    }

    public void skipSubTree(XmlPullParser pp) throws XmlBuilderException {
        try {
            pp.require(2, null, null);
            int level = 1;
            while (level > 0) {
                int eventType = pp.next();
                if (eventType == 3) {
                    --level;
                    continue;
                }
                if (eventType != 2) continue;
                ++level;
            }
        }
        catch (XmlPullParserException e) {
            throw new XmlBuilderException("could not skip subtree", e);
        }
        catch (IOException e) {
            throw new XmlBuilderException("IO error when skipping subtree", e);
        }
    }

    public void serialize(Object item, XmlSerializer serializer) throws XmlBuilderException {
        if (item instanceof Collection) {
            Collection c = (Collection)item;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.serialize(i.next(), serializer);
            }
        } else if (item instanceof XmlContainer) {
            this.serializeContainer((XmlContainer)item, serializer);
        } else {
            this.serializeItem(item, serializer);
        }
    }

    private void serializeContainer(XmlContainer node, XmlSerializer serializer) {
        if (node instanceof XmlPullSerializable) {
            try {
                ((XmlPullSerializable)((Object)node)).serialize(serializer);
            }
            catch (IOException e) {
                throw new XmlBuilderException("could not serialize node " + node + ": " + e, e);
            }
        } else if (node instanceof XmlDocument) {
            this.serializeDocument((XmlDocument)node, serializer);
        } else if (node instanceof XmlElement) {
            this.serializeFragment((XmlElement)node, serializer);
        } else {
            throw new IllegalArgumentException("could not serialzie unknown XML container " + node.getClass());
        }
    }

    public void serializeItem(Object item, XmlSerializer ser) throws XmlBuilderException {
        this.serializeItem(null, item, ser);
    }

    public void serializeItem(XmlElement parent, Object item, XmlSerializer ser) throws XmlBuilderException {
        block9: {
            try {
                if (item instanceof XmlPullSerializable) {
                    try {
                        ((XmlPullSerializable)((Object)item)).serialize(ser);
                        break block9;
                    }
                    catch (IOException e) {
                        throw new XmlBuilderException("could not serialize item " + item + ": " + e, e);
                    }
                }
                if (item instanceof String) {
                    ser.text(((Object)item).toString());
                    break block9;
                }
                if (item instanceof XmlCharacters) {
                    ser.text(((XmlCharacters)((Object)item)).getText());
                    break block9;
                }
                if (item instanceof XmlComment) {
                    ser.comment(((XmlComment)((Object)item)).getContent());
                    break block9;
                }
                String context = "";
                if (parent != null) {
                    context = this.getHeritage(parent);
                }
                throw new IllegalArgumentException("could not serialize " + (item != null ? item.getClass() : item));
            }
            catch (IOException e) {
                throw new XmlBuilderException("serializing XML start tag failed", e);
            }
        }
    }

    public void serializeStartTag(XmlElement el, XmlSerializer ser) {
        try {
            String elPrefix;
            XmlNamespace elNamespace = el.getNamespace();
            String string = elPrefix = elNamespace != null ? elNamespace.getPrefix() : "";
            if (elPrefix == null) {
                elPrefix = "";
            }
            String nToDeclare = null;
            if (el.hasNamespaceDeclarations()) {
                for (XmlNamespace n : el.namespaces()) {
                    String nPrefix = n.getPrefix();
                    if (!elPrefix.equals(nPrefix)) {
                        ser.setPrefix(nPrefix, n.getName());
                        continue;
                    }
                    nToDeclare = n.getName();
                }
            }
            if (nToDeclare != null) {
                ser.setPrefix(elPrefix, nToDeclare);
            } else if (elNamespace != null) {
                String namespaceName = elNamespace.getName();
                if (namespaceName == null) {
                    namespaceName = "";
                }
                String serPrefix = null;
                if (namespaceName.length() > 0) {
                    ser.getPrefix(namespaceName, false);
                }
                if (serPrefix == null) {
                    serPrefix = "";
                }
                if (serPrefix != elPrefix && !serPrefix.equals(elPrefix)) {
                    ser.setPrefix(elPrefix, namespaceName);
                }
            }
            ser.startTag(el.getNamespaceName(), el.getName());
            if (el.hasAttributes()) {
                for (XmlAttribute a : el.attributes()) {
                    if (a instanceof XmlPullSerializable) {
                        ((XmlPullSerializable)((Object)a)).serialize(ser);
                        continue;
                    }
                    ser.attribute(a.getNamespaceName(), a.getName(), a.getValue());
                }
            }
        }
        catch (IOException e) {
            throw new XmlBuilderException("serializing XML start tag failed", e);
        }
    }

    public void serializeEndTag(XmlElement el, XmlSerializer ser) {
        try {
            ser.endTag(el.getNamespaceName(), el.getName());
        }
        catch (IOException e) {
            throw new XmlBuilderException("serializing XML end tag failed", e);
        }
    }

    private void serializeDocument(XmlDocument doc, XmlSerializer ser) {
        try {
            ser.startDocument(doc.getCharacterEncodingScheme(), doc.isStandalone());
        }
        catch (IOException e) {
            throw new XmlBuilderException("serializing XML document start failed", e);
        }
        if (doc.getDocumentElement() == null) {
            throw new XmlBuilderException("could not serialize document without root element " + doc + ": ");
        }
        this.serializeFragment(doc.getDocumentElement(), ser);
        try {
            ser.endDocument();
        }
        catch (IOException e) {
            throw new XmlBuilderException("serializing XML document end failed", e);
        }
    }

    private void serializeFragment(XmlElement el, XmlSerializer ser) {
        this.serializeStartTag(el, ser);
        if (el.hasChildren()) {
            for (Object child : el.children()) {
                if (child instanceof XmlPullSerializable) {
                    try {
                        ((XmlPullSerializable)child).serialize(ser);
                        continue;
                    }
                    catch (IOException e) {
                        throw new XmlBuilderException("could not serialize item " + child + ": " + e, e);
                    }
                }
                if (child instanceof XmlElement) {
                    this.serializeFragment((XmlElement)child, ser);
                    continue;
                }
                this.serializeItem(el, child, ser);
            }
        }
        this.serializeEndTag(el, ser);
    }

    private String getHeritage(XmlElement el) {
        XmlContainer parent = el.getParent();
        String path = parent instanceof XmlElement ? this.getHeritage((XmlElement)parent) + "/" + el.getName() : "/" + el.getName();
        return path;
    }

    @Override
    public void serializeToOutputStream(Object item, OutputStream os, String encoding) throws XmlBuilderException {
        XmlSerializer ser = null;
        try {
            ser = this.factory.newSerializer();
            ser.setOutput(os, encoding);
        }
        catch (Exception e) {
            throw new XmlBuilderException("could not serialize node to output stream (encoding=" + encoding + ")", e);
        }
        this.serialize(item, ser);
        try {
            ser.flush();
        }
        catch (IOException e) {
            throw new XmlBuilderException("could not flush output", e);
        }
    }

    @Override
    public void serializeToWriter(Object item, Writer writer) throws XmlBuilderException {
        XmlSerializer ser = null;
        try {
            ser = this.factory.newSerializer();
            ser.setOutput(writer);
        }
        catch (Exception e) {
            throw new XmlBuilderException("could not serialize node to writer", e);
        }
        this.serialize(item, ser);
        try {
            ser.flush();
        }
        catch (IOException e) {
            throw new XmlBuilderException("could not flush output", e);
        }
    }

    @Override
    public void serializeToWriter(Object item, Writer writer, boolean pretty) throws XmlBuilderException {
        XmlSerializer ser = null;
        try {
            ser = this.factory.newSerializer();
            ser.setOutput(writer);
            ser.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        }
        catch (Exception e) {
            throw new XmlBuilderException("could not serialize node to writer", e);
        }
        this.serialize(item, ser);
        try {
            ser.flush();
        }
        catch (IOException e) {
            throw new XmlBuilderException("could not flush output", e);
        }
    }
}

