/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccess
extends AccessStrategy {
    private final Class<?> beanClass;
    private final String propertyName;
    private Field rememberField;

    public PropertyAccess(Class<?> clazz, String propertyName) {
        this.beanClass = clazz;
        this.propertyName = propertyName;
    }

    @Override
    public ElementType getElementType() {
        return this.rememberField != null ? ElementType.FIELD : ElementType.METHOD;
    }

    private static Object getPublicProperty(Object bean, String property) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (bean instanceof Map) {
            return ((Map)bean).get(property);
        }
        return PropertyUtils.getSimpleProperty(bean, property);
    }

    public static Object getProperty(Object bean, String propertyName) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        return new PropertyAccess(bean.getClass(), propertyName).get(bean);
    }

    public String toString() {
        return "Property{" + this.beanClass.getName() + '.' + this.propertyName + '}';
    }

    @Override
    public Type getJavaType() {
        if (this.rememberField != null) {
            return this.rememberField.getGenericType();
        }
        for (PropertyDescriptor each : PropertyUtils.getPropertyDescriptors(this.beanClass)) {
            if (!each.getName().equals(this.propertyName) || each.getReadMethod() == null) continue;
            return each.getReadMethod().getGenericReturnType();
        }
        try {
            return this.beanClass.getField(this.propertyName).getGenericType();
        }
        catch (NoSuchFieldException ex2) {
            for (Class<?> theClass = this.beanClass; theClass != null; theClass = theClass.getSuperclass()) {
                try {
                    return theClass.getDeclaredField(this.propertyName).getGenericType();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return Object.class;
        }
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Object get(Object bean) {
        try {
            if (this.rememberField != null) {
                return this.rememberField.get(bean);
            }
            try {
                return PropertyAccess.getPublicProperty(bean, this.propertyName);
            }
            catch (NoSuchMethodException ex) {
                return this.getFieldValue(bean);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot access " + this.propertyName, e);
        }
    }

    private Object getFieldValue(Object bean) throws IllegalAccessException {
        try {
            Field aField = bean.getClass().getField(this.propertyName);
            Object value = aField.get(bean);
            this.rememberField = aField;
            return value;
        }
        catch (NoSuchFieldException ex2) {
            for (Class<?> theClass = bean.getClass(); theClass != null; theClass = theClass.getSuperclass()) {
                try {
                    Field aField = theClass.getDeclaredField(this.propertyName);
                    if (!aField.isAccessible()) {
                        aField.setAccessible(true);
                    }
                    Object value = aField.get(bean);
                    this.rememberField = aField;
                    return value;
                }
                catch (NoSuchFieldException ex3) {
                    continue;
                }
            }
            throw new IllegalArgumentException("cannot access field " + this.propertyName);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyAccess that = (PropertyAccess)o;
        return this.beanClass.equals(that.beanClass) && this.propertyName.equals(that.propertyName);
    }

    public int hashCode() {
        int result = this.beanClass.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        return result;
    }
}

