/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DeprecateWorkflowTypeRequestMarshaller
implements Marshaller<Request<DeprecateWorkflowTypeRequest>, DeprecateWorkflowTypeRequest> {
    public Request<DeprecateWorkflowTypeRequest> marshall(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) {
        if (deprecateWorkflowTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deprecateWorkflowTypeRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.DeprecateWorkflowType";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            WorkflowType workflowType;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (deprecateWorkflowTypeRequest.getDomain() != null) {
                jsonWriter.key("domain").value((Object)deprecateWorkflowTypeRequest.getDomain());
            }
            if ((workflowType = deprecateWorkflowTypeRequest.getWorkflowType()) != null) {
                jsonWriter.key("workflowType");
                jsonWriter.object();
                if (workflowType.getName() != null) {
                    jsonWriter.key("name").value((Object)workflowType.getName());
                }
                if (workflowType.getVersion() != null) {
                    jsonWriter.key("version").value((Object)workflowType.getVersion());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

