/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.NotFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitNotFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitNotFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitNotFilter() {
        super("Initialize NOT filter");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04009, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        NotFilter notFilter = new NotFilter(container.getTlvId());
        searchRequestDecorator.addCurrentFilter(notFilter);
        if (IS_DEBUG) {
            LOG.debug("Initialize NOT filter");
        }
    }
}

