/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.AbstractFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ResourceFileData;

public class ServiceGroupFilePersistenceManager
extends AbstractFilePersistenceManager {
    private static final Log log = LogFactory.getLog(ServiceGroupFilePersistenceManager.class);

    public ServiceGroupFilePersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        super(axisConfig);
        try {
            URL repositoryURL = axisConfig.getRepository();
            if (repositoryURL != null) {
                String repoPath = URLDecoder.decode(axisConfig.getRepository().getPath(), "UTF-8");
                this.metafilesDir = new File(repoPath + File.separator + "servicemetafiles");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"metafiles directory URL can not be decoded.", (Throwable)e);
            throw new AxisFault("metafiles directory URL can not be decoded.", (Throwable)e);
        }
        if (this.metafilesDir == null) {
            log.error((Object)"metafiles directory for services must exist. ");
            throw new AxisFault("metafiles directory for services must exist. May be AxisConfiguration does not have the repository url set.");
        }
    }

    @Override
    public synchronized void beginTransaction(String serviceGroupId) throws PersistenceException {
        File sgFile = new File(this.metafilesDir, this.getFilePathFromResourceId(serviceGroupId));
        try {
            if (this.resourceMap.get(serviceGroupId) != null && ((ResourceFileData)this.resourceMap.get(serviceGroupId)).isTransactionStarted()) {
                throw new PersistenceException("A transaction is already started for this service group. Nested transactions are no longer supported in this persistence model - " + serviceGroupId);
            }
            OMElement sgElement = sgFile.exists() ? PersistenceUtils.getResourceDocumentElement(sgFile) : this.omFactory.createOMElement("serviceGroup", null);
            ResourceFileData fileData = new ResourceFileData(sgElement, sgFile, true);
            this.resourceMap.put(serviceGroupId, fileData);
        }
        catch (XMLStreamException e1) {
            log.error((Object)"Failed to use XMLStreamReader. Exception in beginning the transaction ", (Throwable)e1);
            throw new PersistenceException("Exception in beginning the transaction ", e1);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File not found. Exception in beginning the transaction " + sgFile.getAbsolutePath()), (Throwable)e);
            throw new PersistenceException("Exception in beginning the transaction", e);
        }
        catch (IOException e) {
            log.error((Object)("Exception in closing service group file " + serviceGroupId), (Throwable)e);
            throw new PersistenceException("Exception in closing service group file", e);
        }
    }

    @Override
    public OMElement get(String serviceGroupId) throws PersistenceDataNotFoundException {
        return (OMElement)this.get(serviceGroupId, "/");
    }

    public List getAssociations(String serviceGroupId, String xpathOfParentElement, String associationName) throws PersistenceDataNotFoundException {
        String associationXPath = xpathOfParentElement + "/" + "association" + PersistenceUtils.getXPathAttrPredicate("type", associationName);
        return this.getAll(serviceGroupId, associationXPath);
    }

    @Override
    public boolean delete(String serviceGroupId, String xpathStrOfElement) {
        return super.delete(serviceGroupId, xpathStrOfElement);
    }

    @Override
    public void init() {
        try {
            if (!this.metafilesDir.exists()) {
                FileUtils.forceMkdir((File)this.metafilesDir);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error creating the services meta files directory " + this.metafilesDir.getAbsolutePath()), (Throwable)e);
        }
    }
}

