/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteApplicationVersionRequestMarshaller
implements Marshaller<Request<DeleteApplicationVersionRequest>, DeleteApplicationVersionRequest> {
    public Request<DeleteApplicationVersionRequest> marshall(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        if (deleteApplicationVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteApplicationVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DeleteApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        if (deleteApplicationVersionRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)deleteApplicationVersionRequest.getApplicationName()));
        }
        if (deleteApplicationVersionRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)deleteApplicationVersionRequest.getVersionLabel()));
        }
        if (deleteApplicationVersionRequest.isDeleteSourceBundle() != null) {
            request.addParameter("DeleteSourceBundle", StringUtils.fromBoolean((Boolean)deleteApplicationVersionRequest.isDeleteSourceBundle()));
        }
        return request;
    }
}

