/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.helpers.proxy.ProxyAddressRestrictionData;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.CertificateExtension;
import eu.emi.security.authn.x509.proxy.ProxyChainInfo;
import eu.emi.security.authn.x509.proxy.ProxyChainType;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyType;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public abstract class BaseProxyCertificateOptions {
    public static final int DEFAULT_KEY_USAGE = 176;
    public static final int DEFAULT_LIFETIME = 43200;
    private final X509Certificate[] parentChain;
    private int lifetime = 43200;
    private Date notBefore;
    private ProxyType type;
    private boolean limited = false;
    private BigInteger serialNumber = null;
    private int proxyPathLimit = -1;
    private int proxyKeyUsageMask = -1;
    private List<CertificateExtension> extensions;
    private ProxyPolicy policy = null;
    private String[] targetRestrictionPermitted;
    private String[] targetRestrictionExcluded;
    private String[] sourceRestrictionPermitted;
    private String[] sourceRestrictionExcluded;
    private String proxyTracingSubject;
    private String proxyTracingIssuer;
    private String samlAssertion;
    private AttributeCertificate[] attributeCertificates;

    protected BaseProxyCertificateOptions(X509Certificate[] parentCertChain) {
        if (parentCertChain == null || parentCertChain.length == 0) {
            throw new IllegalArgumentException("parent certificate chain must be set");
        }
        this.parentChain = Arrays.copyOf(parentCertChain, parentCertChain.length);
        this.extensions = new ArrayList<CertificateExtension>();
        this.notBefore = new Date();
        if (ProxyUtils.isProxy(parentCertChain)) {
            ProxyChainType pct;
            try {
                pct = new ProxyChainInfo(parentCertChain).getProxyType();
            }
            catch (CertificateException e) {
                throw new IllegalArgumentException("Can not parse the parentCertChain argument", e);
            }
            this.type = pct == ProxyChainType.RFC3820 ? ProxyType.RFC3820 : (pct == ProxyChainType.DRAFT_RFC ? ProxyType.DRAFT_RFC : (pct == ProxyChainType.LEGACY ? ProxyType.LEGACY : ProxyType.RFC3820));
        } else {
            this.type = ProxyType.RFC3820;
        }
    }

    public X509Certificate[] getParentCertChain() {
        return this.parentChain;
    }

    public void setValidityBounds(Date notBefore, Date notAfter) {
        this.notBefore = new Date();
        this.notBefore.setTime(notBefore.getTime() / 1000L * 1000L);
        if (notAfter.before(notBefore)) {
            throw new IllegalArgumentException("notBefore argument value must be earlier than notAfter");
        }
        this.lifetime = (int)(notAfter.getTime() / 1000L - notBefore.getTime() / 1000L);
    }

    public void setLifetime(int lifetime) {
        this.notBefore = new Date();
        this.lifetime = lifetime;
    }

    public void setLifetime(long lifetime, TimeUnit unit) {
        long secLifetime = unit.toSeconds(lifetime);
        if (secLifetime > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This implementation allows for proxy lifetimes up to 2147483647 seconds");
        }
        this.setLifetime((int)secLifetime);
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public int getProxyKeyUsageMask() {
        return this.proxyKeyUsageMask;
    }

    public void setProxyKeyUsageMask(int proxyKeyUsageMask) throws IllegalArgumentException {
        if ((proxyKeyUsageMask & 0x80) == 0) {
            throw new IllegalArgumentException("The digital signature bit must be always set for the proxy");
        }
        this.proxyKeyUsageMask = proxyKeyUsageMask;
    }

    public void setType(ProxyType type) throws IllegalArgumentException {
        this.type = type;
    }

    public ProxyType getType() {
        return this.type;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
        if (limited) {
            this.setPolicy(new ProxyPolicy("1.3.6.1.4.1.3536.1.1.1.9"));
        } else {
            this.setPolicy(new ProxyPolicy("1.3.6.1.5.5.7.21.1"));
        }
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setSerialNumber(BigInteger sn) {
        this.serialNumber = sn;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setProxyPathLimit(int pathLen) {
        this.proxyPathLimit = pathLen;
    }

    public int getProxyPathLimit() {
        return this.proxyPathLimit;
    }

    public void addExtension(CertificateExtension extension) {
        this.extensions.add(extension);
    }

    public List<CertificateExtension> getExtensions() {
        ArrayList<CertificateExtension> ret = new ArrayList<CertificateExtension>(this.extensions.size());
        ret.addAll(this.extensions);
        return ret;
    }

    public void setPolicy(ProxyPolicy policy) {
        this.policy = policy.clone();
    }

    public ProxyPolicy getPolicy() {
        return this.policy == null ? null : this.policy.clone();
    }

    public void setTargetRestrictionPermittedAddresses(String[] addresses) throws IllegalArgumentException {
        this.targetRestrictionPermitted = (String[])addresses.clone();
    }

    public void setTargetRestrictionPermittedAddresses(byte[][] addresses) throws IllegalArgumentException {
        this.targetRestrictionPermitted = ProxyAddressRestrictionData.convert2strings(addresses);
    }

    public String[] getTargetRestrictionPermittedAddresses() {
        return this.targetRestrictionPermitted == null ? null : (String[])this.targetRestrictionPermitted.clone();
    }

    public void setSourceRestrictionPermittedAddresses(String[] addresses) throws IllegalArgumentException {
        this.sourceRestrictionPermitted = (String[])addresses.clone();
    }

    public void setSourceRestrictionPermittedAddresses(byte[][] addresses) throws IllegalArgumentException {
        this.sourceRestrictionPermitted = ProxyAddressRestrictionData.convert2strings(addresses);
    }

    public String[] getSourceRestrictionPermittedAddresses() {
        return this.sourceRestrictionPermitted == null ? null : (String[])this.sourceRestrictionPermitted.clone();
    }

    public void setTargetRestrictionExcludedAddresses(String[] addresses) throws IllegalArgumentException {
        this.targetRestrictionExcluded = (String[])addresses.clone();
    }

    public void setTargetRestrictionExcludedAddresses(byte[][] addresses) throws IllegalArgumentException {
        this.targetRestrictionExcluded = ProxyAddressRestrictionData.convert2strings(addresses);
    }

    public String[] getTargetRestrictionExcludedAddresses() {
        return this.targetRestrictionExcluded == null ? null : (String[])this.targetRestrictionExcluded.clone();
    }

    public void setSourceRestrictionExcludedAddresses(String[] addresses) throws IllegalArgumentException {
        this.sourceRestrictionExcluded = (String[])addresses.clone();
    }

    public void setSourceRestrictionExcludedAddresses(byte[][] addresses) throws IllegalArgumentException {
        this.sourceRestrictionExcluded = ProxyAddressRestrictionData.convert2strings(addresses);
    }

    public String[] getSourceRestrictionExcludedAddresses() {
        return this.sourceRestrictionExcluded == null ? null : (String[])this.sourceRestrictionExcluded.clone();
    }

    public void setProxyTracingIssuer(String url) {
        this.proxyTracingIssuer = url;
    }

    public String getProxyTracingIssuer() {
        return this.proxyTracingIssuer;
    }

    public void setProxyTracingSubject(String url) {
        this.proxyTracingSubject = url;
    }

    public String getProxyTracingSubject() {
        return this.proxyTracingSubject;
    }

    public String getSAMLAssertion() {
        return this.samlAssertion;
    }

    public void setSAMLAssertion(String saml) {
        this.samlAssertion = saml;
    }

    public void setAttributeCertificates(AttributeCertificate[] ac) throws IOException {
        this.attributeCertificates = new AttributeCertificate[ac.length];
        for (int i = 0; i < ac.length; ++i) {
            this.attributeCertificates[i] = AttributeCertificate.getInstance((Object)ac[i].getEncoded("DER"));
        }
    }

    public AttributeCertificate[] getAttributeCertificates() throws IOException {
        if (this.attributeCertificates == null) {
            return null;
        }
        AttributeCertificate[] ret = new AttributeCertificate[this.attributeCertificates.length];
        for (int i = 0; i < this.attributeCertificates.length; ++i) {
            ret[i] = AttributeCertificate.getInstance((Object)this.attributeCertificates[i].getEncoded("DER"));
        }
        return ret;
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

