/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ConvertVariableDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ConvertBodyReifier;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.processor.ConvertVariableProcessor;

public class ConvertVariableReifier
extends ProcessorReifier<ConvertVariableDefinition> {
    public ConvertVariableReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ConvertVariableDefinition)ConvertVariableDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        String key = this.parseString(((ConvertVariableDefinition)this.definition).getName());
        Expression nameExpr = LanguageSupport.hasSimpleFunction((String)key) ? this.camelContext.resolveLanguage("simple").createExpression(key) : this.camelContext.resolveLanguage("constant").createExpression(key);
        nameExpr.init(this.camelContext);
        String toKey = this.parseString(((ConvertVariableDefinition)this.definition).getToName());
        Expression toNameExpr = null;
        if (toKey != null) {
            toNameExpr = LanguageSupport.hasSimpleFunction((String)toKey) ? this.camelContext.resolveLanguage("simple").createExpression(toKey) : this.camelContext.resolveLanguage("constant").createExpression(toKey);
            toNameExpr.init(this.camelContext);
        }
        Class typeClass = this.parse(Class.class, this.or(((ConvertVariableDefinition)this.definition).getTypeClass(), this.parseString(((ConvertVariableDefinition)this.definition).getType())));
        String charset = ConvertVariableReifier.validateCharset(this.parseString(((ConvertVariableDefinition)this.definition).getCharset()));
        boolean mandatory = true;
        if (((ConvertVariableDefinition)this.definition).getMandatory() != null) {
            mandatory = this.parseBoolean(((ConvertVariableDefinition)this.definition).getMandatory(), true);
        }
        ConvertVariableProcessor answer = new ConvertVariableProcessor(key, nameExpr, toKey, toNameExpr, typeClass, charset, mandatory);
        answer.setDisabled(ConvertVariableReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }

    public static String validateCharset(String charset) throws UnsupportedCharsetException {
        return ConvertBodyReifier.validateCharset(charset);
    }
}

