/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cluster;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.support.cluster.ClusterServiceSelectors;
import org.apache.camel.util.ObjectHelper;

public final class ClusterServiceHelper {
    private ClusterServiceHelper() {
    }

    public static Optional<CamelClusterService> lookupService(CamelContext context) {
        return ClusterServiceHelper.lookupService(context, ClusterServiceSelectors.DEFAULT_SELECTOR);
    }

    public static Optional<CamelClusterService> lookupService(CamelContext context, CamelClusterService.Selector selector) {
        ObjectHelper.notNull((Object)context, (String)"Camel Context");
        ObjectHelper.notNull((Object)selector, (String)"ClusterService selector");
        Set services = context.hasServices(CamelClusterService.class);
        if (ObjectHelper.isNotEmpty((Collection)services)) {
            return selector.select((Collection)services);
        }
        return Optional.empty();
    }

    public static CamelClusterService mandatoryLookupService(CamelContext context) {
        return ClusterServiceHelper.lookupService(context).orElseThrow(() -> new IllegalStateException("CamelCluster service not found"));
    }

    public static CamelClusterService mandatoryLookupService(CamelContext context, CamelClusterService.Selector selector) {
        return ClusterServiceHelper.lookupService(context, selector).orElseThrow(() -> new IllegalStateException("CamelCluster service not found"));
    }
}

