
RSpec.describe Msf::Exploit::Remote::HTTP::Joomla::Base do

  subject do
    mod = ::Msf::Exploit.new
    mod.extend ::Msf::Exploit::Remote::HTTP::Joomla
    mod.send(:initialize)
    mod
  end

  let(:joomla_body) do
    %Q|
    <!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-gb" lang="en-gb" dir="ltr">
    <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <base href="http://172.16.23.131/joomla/" />
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta name="description" content="test" />
    <meta name="generator" content="Joomla! - Open Source Content Management" />
    <title>Home</title>
    </head>
    </html>
    |
  end

  let(:rex_http_response) do
    res = Rex::Proto::Http::Response.new
    res.code = 200
    res.body = joomla_body
    res
  end

  before(:example) do
    allow(subject).to receive(:send_request_cgi) do |opts|
      rex_http_response
    end
  end

  describe '#joomla_and_online?' do
    context 'When site is Joomla' do
      it { expect(subject.joomla_and_online?).to be_truthy }
    end
  end

end
