/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd1;

import com.google.common.base.Strings;
import com.jthink.brainz.mmd.Artist;
import com.jthink.brainz.mmd.ArtistList;
import com.jthink.brainz.mmd.LifeSpan;
import com.jthink.brainz.mmd.Metadata;
import com.jthink.brainz.mmd.ObjectFactory;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.Mmd1XmlWriter;

public class ArtistMmd1XmlWriter
extends Mmd1XmlWriter {
    public Metadata write(Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        ArtistList artistList = of.createArtistList();
        for (Result result : results.results) {
            MbDocument doc = result.getDoc();
            Artist artist = of.createArtist();
            result.setNormalizedScore(results.getMaxScore());
            artist.getOtherAttributes().put(this.getScore(), String.valueOf(result.getNormalizedScore()));
            org.musicbrainz.mmd2.Artist artistv2 = (org.musicbrainz.mmd2.Artist)MMDSerializer.unserialize((String)doc.get((IndexField)ArtistIndexField.ARTIST_STORE), org.musicbrainz.mmd2.Artist.class);
            artist.setId(artistv2.getId());
            artist.setType(StringUtils.capitalize((String)artistv2.getType()));
            artist.setName(artistv2.getName());
            if (!Strings.isNullOrEmpty((String)artistv2.getSortName())) {
                artist.setSortName(artistv2.getSortName());
            }
            if (!Strings.isNullOrEmpty((String)artistv2.getDisambiguation())) {
                artist.setDisambiguation(artistv2.getDisambiguation());
            }
            if (artistv2.getLifeSpan() != null) {
                String begin = artistv2.getLifeSpan().getBegin();
                String end = artistv2.getLifeSpan().getEnd();
                if (begin != null || end != null) {
                    LifeSpan lifespan = of.createLifeSpan();
                    if (begin != null) {
                        lifespan.setBegin(begin);
                    }
                    if (end != null) {
                        lifespan.setEnd(end);
                    }
                    artist.setLifeSpan(lifespan);
                }
            }
            artistList.getArtist().add(artist);
        }
        artistList.setCount(BigInteger.valueOf(results.getTotalHits()));
        artistList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setArtistList(artistList);
        return metadata;
    }
}

