/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class EscapingXMLStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter writer;
    public static final char substitute = '\'';
    private static final HashSet<Character> illegalChars;

    public EscapingXMLStreamWriter(XMLStreamWriter writer) {
        if (null == writer) {
            throw new IllegalArgumentException("null");
        }
        this.writer = writer;
    }

    private boolean isIllegal(char c) {
        return illegalChars.contains(Character.valueOf(c));
    }

    private String escapeCharacters(String string) {
        char[] copy = null;
        boolean copied = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!this.isIllegal(string.charAt(i))) continue;
            if (!copied) {
                copy = string.toCharArray();
                copied = true;
            }
            copy[i] = 39;
        }
        return copied ? new String(copy) : string;
    }

    @Override
    public void writeStartElement(String s) throws XMLStreamException {
        this.writer.writeStartElement(s);
    }

    @Override
    public void writeStartElement(String s, String s1) throws XMLStreamException {
        this.writer.writeStartElement(s, s1);
    }

    @Override
    public void writeStartElement(String s, String s1, String s2) throws XMLStreamException {
        this.writer.writeStartElement(s, s1, s2);
    }

    @Override
    public void writeEmptyElement(String s, String s1) throws XMLStreamException {
        this.writer.writeEmptyElement(s, s1);
    }

    @Override
    public void writeEmptyElement(String s, String s1, String s2) throws XMLStreamException {
        this.writer.writeEmptyElement(s, s1, s2);
    }

    @Override
    public void writeEmptyElement(String s) throws XMLStreamException {
        this.writer.writeEmptyElement(s);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceUri, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceUri, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceUri, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceUri, localName, value);
    }

    @Override
    public void writeNamespace(String s, String s1) throws XMLStreamException {
        this.writer.writeNamespace(s, s1);
    }

    @Override
    public void writeDefaultNamespace(String s) throws XMLStreamException {
        this.writer.writeDefaultNamespace(s);
    }

    @Override
    public void writeComment(String s) throws XMLStreamException {
        this.writer.writeComment(s);
    }

    @Override
    public void writeProcessingInstruction(String s) throws XMLStreamException {
        this.writer.writeProcessingInstruction(s);
    }

    @Override
    public void writeProcessingInstruction(String s, String s1) throws XMLStreamException {
        this.writer.writeProcessingInstruction(s, s1);
    }

    @Override
    public void writeCData(String s) throws XMLStreamException {
        this.writer.writeCData(this.escapeCharacters(s));
    }

    @Override
    public void writeDTD(String s) throws XMLStreamException {
        this.writer.writeDTD(s);
    }

    @Override
    public void writeEntityRef(String s) throws XMLStreamException {
        this.writer.writeEntityRef(s);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String s) throws XMLStreamException {
        this.writer.writeStartDocument(s);
    }

    @Override
    public void writeStartDocument(String s, String s1) throws XMLStreamException {
        this.writer.writeStartDocument(s, s1);
    }

    @Override
    public void writeCharacters(String s) throws XMLStreamException {
        this.writer.writeCharacters(this.escapeCharacters(s));
    }

    @Override
    public void writeCharacters(char[] chars, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(this.escapeCharacters(new String(chars, start, len)));
    }

    @Override
    public String getPrefix(String s) throws XMLStreamException {
        return this.writer.getPrefix(s);
    }

    @Override
    public void setPrefix(String s, String s1) throws XMLStreamException {
        this.writer.setPrefix(s, s1);
    }

    @Override
    public void setDefaultNamespace(String s) throws XMLStreamException {
        this.writer.setDefaultNamespace(s);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.writer.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String s) throws IllegalArgumentException {
        return this.writer.getProperty(s);
    }

    static {
        String escapeString = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff";
        illegalChars = new HashSet();
        for (int i = 0; i < "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff".length(); ++i) {
            illegalChars.add(Character.valueOf("\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff".charAt(i)));
        }
    }
}

