<?php
/**
 * Passwd Base Class.
 *
 * $Horde: passwd/lib/Passwd.php,v 1.3 2003/05/22 20:23:34 chuck Exp $
 *
 * @author Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.3 $
 * @package passwd
 */
class Passwd {

    function menu()
    {
        global $notification, $registry, $conf;
        require_once HORDE_BASE . '/lib/Menu.php';
        require PASSWD_TEMPLATES . '/menu/menu.inc';

        $notification->notify();

        /* Include the JavaScript for the help system (if enabled). */
        Help::javascript();
    }

    /**
     * Determines if the given backend is the "preferred" backend for
     * this web server.  This decision is based on the global
     * 'SERVER_NAME' and 'HTTP_HOST' server variables and the contents
     * of the 'preferred' field in the backend's definition.  The
     * 'preferred' field may take a single value or an array of
     * multiple values.
     *
     * @param array $backend     A complete backend entry from the $backends
     *                           hash.
     *
     * @return boolean  True if this entry is "preferred".
     */
    function isPreferredBackend($backend)
    {
        if (!empty($backend['preferred'])) {
            if (is_array($backend['preferred'])) {
                foreach ($backend['preferred'] as $backend) {
                    if ($backend == $_SERVER['SERVER_NAME'] ||
                        $backend == $_SERVER['HTTP_HOST']) {
                        return true;
                    }
                }
            } elseif ($backend['preferred'] == $_SERVER['SERVER_NAME'] ||
                      $backend['preferred'] == $_SERVER['HTTP_HOST']) {
                return true;
            }
        }

        return false;
    }

}
