<?php
/**
 * $Horde: nag/prefs.php,v 1.28 2003/05/23 03:56:11 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

function handle_category_management($updated)
{
    $actionID = Horde::getFormData('managementActionID');
    $categoryID = Horde::getFormData('category_id');
    $categoryName = Horde::getFormData('category_name');

    switch ($actionID) {
        case NAG_DELETE_CATEGORY:
            Nag::deleteCategory($categoryID);
            break;

        case NAG_RENAME_CATEGORY:
            Nag::renameCategory($categoryID, $categoryName);
            break;

        case NAG_ADD_CATEGORY:
            Nag::addCategory($categoryName);
            break;

        default:
            /* must have been the Save button */
            return true;
    }

    /* return false so it stays on this page */
    return false;
}

function handle_tasklistselect($updated)
{
    global $prefs;

    $default_tasklist = Horde::getFormData('default_tasklist');
    if (!is_null($default_tasklist)) {
        $tasklists = Nag::listTasklists();
        if (is_array($tasklists) && isset($tasklists[$default_tasklist])) {
            $prefs->setValue('default_tasklist', $default_tasklist);
            $updated = true;
        }
    }
    return $updated;
}

function handle_showsummaryselect($updated)
{
    global $prefs;

    $summary_categories = Horde::getFormData('summary_categories');
    $prefs->setValue('summary_categories', $summary_categories);
    return true;
}

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require NAG_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    require NAG_BASE . '/config/prefs.php';
}

$title = _("User Options");
require NAG_TEMPLATES . '/common-header.inc';
Nag::menu();

$default_task_category_options = Nag::listCategories();

PrefsUI::generateUI($group);

require NAG_TEMPLATES . '/common-footer.inc';
