<?php
/**
 * $Horde: nag/list.php,v 1.58 2003/07/04 16:52:11 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

/* Allow preferred theme to override settings. */
Horde::getThemeConfig(NAG_BASE);

/* Get the current action ID. */
$actionID = Horde::getFormData('actionID');

/* Sort out the sorting values and task filtering. */
if (($sortby = Horde::getFormData('sortby')) !== null) {
    $prefs->setValue('sortby', $sortby);
}
if (($sortdir = Horde::getFormData('sortdir')) !== null) {
    $prefs->setValue('sortdir', $sortdir);
}
if (($show_completed = Horde::getFormData('show_completed')) !== null) {
    $prefs->setValue('show_completed', $show_completed);
}

/* Get the full, sorted task list. */
$tasks = Nag::listTasks($prefs->getValue('sortby'),
                        $prefs->getValue('sortdir'));

/* Page variables. */
$i = 0;
$title = _("Tasks");

switch ($actionID) {
case NAG_SEARCH_TASKS:
    /* If we're searching, only list those tasks that match the
       search result. */
    /* Get the search parameters. */
    $pattern = Horde::getFormData('search_pattern');
    $search_name = (Horde::getFormData('search_name') == 'on');
    $search_desc = (Horde::getFormData('search_desc') == 'on');
    $search_category = (Horde::getFormData('search_category') == 'on');

    if (!empty($pattern) && ($search_name || $search_desc || $search_category)) {
        if ($search_category) {
            $categories = Nag::listAllCategories();
        }

        $pattern = '/' . preg_quote($pattern, '/') . '/i';
        $search_results = array();
        foreach ($tasks as $task_id => $task) {
            if (($search_name && preg_match($pattern, $task['name'])) || 
                ($search_desc && preg_match($pattern, $task['desc'])) ||
                ($search_category && !empty($categories[$task['tasklist_id']][$task['category']]) && preg_match($pattern, $categories[$task['tasklist_id']][$task['category']]))) {
                $search_results[$task_id] = $task;
            }
        }

        /* Reassign $tasks to the search result. */
        $tasks = $search_results;
        $title = _("Search Results");
    }
    break;
}

$list = Horde::applicationUrl('list.php');
$all_link = Horde::link(Horde::addParameter($list, 'show_completed=1'), _("All tasks"), 'menuitem') . _("All tasks") . '</a>';
$complete_link = Horde::link(Horde::addParameter($list, 'show_completed=2'), _("Complete tasks"), 'menuitem') . _("Complete tasks") . '</a>';
$incomplete_link = Horde::link(Horde::addParameter($list, 'show_completed=0'), _("Incomplete tasks"), 'menuitem') . _("Incomplete tasks") . '</a>';
switch ($prefs->getValue('show_completed')) {
 case 1: // All tasks
     $all_link = _("All tasks");
     break;

 case 0: // Incomplete tasks
     $incomplete_link = _("Incomplete tasks");
     break;

 case 2: // Complete tasks
     $complete_link = _("Complete tasks");
     break;
}

require NAG_TEMPLATES . '/common-header.inc';
Nag::menu();
require NAG_TEMPLATES . '/list/javascript.inc';
require NAG_TEMPLATES . '/list/header.inc';

if (count($tasks)) {
    require NAG_TEMPLATES . '/list/task_headers.inc';

    foreach ($tasks as $task_id => $task) {
        $tstyle = '';
        if (!empty($task['completed'])) {
            $style = 'closed';
            $tstyle = 'linethrough';
        } elseif (!empty($task['due']) && $task['due'] < time()) {
            $style = 'overdue';
            $tstyle = 'overdue';
        } else {
            $style = 'text';
        }
        if ($task['tasklist_id'] == '**EXTERNAL**') {
            // Just use a new share that this user owns for tasks from
            // external calls - if the API gives them back, we'll
            // trust it.
            $share = $GLOBALS['nag_shares']->newShare('**EXTERNAL**');
            $share->setOwner(Auth::getAuth());
        } else {
            $share = $GLOBALS['nag_shares']->getShare($task['tasklist_id']);
        }

        $owner = $task['tasklist_id'];
        if (!is_a($share, 'PEAR_Error') && $owner != $share->getOwner()) {
            $owner = $share->getShareName();
        }

        require NAG_TEMPLATES . '/list/task_summaries.inc';
    }

    require NAG_TEMPLATES . '/list/task_footers.inc';
} else {
    require NAG_TEMPLATES . '/list/empty.inc';
}

require NAG_TEMPLATES . '/list/footer.inc';
require NAG_TEMPLATES . '/common-footer.inc';
