<?php
/**
 * Moment external API interface.
 *
 * This file defines Moments's external API interface.  Other applications can
 * interact with Moment through this API.
 *
 * $Horde: moment/lib/api.php,v 1.9 2003/09/01 22:56:37 jan Exp $
 */

// meeting/list
$_services['list'] = array(
    'args' => array('sortby', 'sortdir'),
    'type' => 'array');

// meeting/show
$_services['show'] = array(
    'link' => '%application%/viewMeeting.php?meetingID=|meeting|');

// meeting/update_attendees
$_services['update_attendees'] = array(
    'args' => array('sender', 'vevent'),
    'type' => 'boolean');

// meeting/vevent_from_uid
$_services['vevent_from_uid'] = array(
    'args' => array('uid'),
    'type' => 'object');

// calendar/import_vfreebusy
$_services['import_vfreebusy'] = array(
    'args' => array('vfb', 'public'),
    'type' => 'boolean');

// meeting/block
$_services['block'] = array(
    'args' => array('type', 'params'),
    'type' => 'array');

// meeting/blocks
$_services['blocks'] = array(
    'args' => array(),
    'type' => 'array');

function _moment_block($type, $params)
{
    @define('MOMENT_BASE', dirname(__FILE__) . '/..');
    require_once MOMENT_BASE . '/lib/base.php';

    $class = 'Moment_' . $type . '_Block';
    require_once MOMENT_BASE . '/lib/Block/' . $type . '.php';
    return new $class($params);
}

function _moment_blocks()
{
    $blocks = array('summary' => array('name' => _("Meetings Summary"),
                                       'type' => 'summary',
                                       'params' => array(),
                                       ),
                   );

    return $blocks;
}

function _moment_list($sortby = null, $sortdir = null)
{
    global $conf, $prefs;
    require_once dirname(__FILE__) . '/base.php';

    if (!isset($sortby)) {
        $sortby = $prefs->getValue('sortby');
    }
    if (!isset($sortdir)) {
        $sortdir = $prefs->getValue('sortdir');
    }

    return Moment::listMeetings($sortby, $sortdir);
}

function _moment_import_vfreebusy($vfb, $public = false)
{
    global $conf;
    require_once dirname(__FILE__) . '/base.php';
    require_once MOMENT_BASE . '/lib/Storage.php';

    $storage = &Moment_Storage::singleton();

    $email = $vfb->getEmail();
    $res = $storage->store($email, $vfb, $public);

    return $res;
}

function _moment_update_attendees($sender, $vevent)
{
    global $conf;
    require_once dirname(__FILE__) . '/base.php';
    require_once MOMENT_BASE . '/lib/Storage.php';

    /* Create a driver instance. */
    $driver = &Moment_Driver::singleton();
    $driver->retrieve();
    $meeting_id = $driver->getMeetingIdByUid($vevent->getAttribute('UID'));
    if (is_a($meeting_id, 'PEAR_Error')) {
        return $meeting_id;
    }

    $meeting = $driver->getMeeting($meeting_id);
    if (is_a($meeting, 'PEAR_Error')) {
        return $meeting;
    }

    $event_attendees = $meeting['attendees'];
    $reply_attendees = $vevent->getAttribute('ATTENDEE');
    $reply_attendees_params = $vevent->getAttribute('ATTENDEE', true);

    if (!is_array($reply_attendees)) {
        // only one attendee
        $reply_attendees = array($reply_attendees);
    }

    $new_status = array();
    foreach ($reply_attendees as $id => $url) {
        $parts = parse_url($url);
        $new_status[$parts['path']] = String::lower($reply_attendees_params[$id]['PARTSTAT']);
    }

    $found = false;
    foreach ($event_attendees as $id => $value) {
        if (isset($new_status[$value['email']]) && strpos($sender, $value['email']) !== false) {
            $event_attendees[$id]['responce'] = $new_status[$value['email']];
            $found = true;
        }
    }

    if (!$found && isset($new_status[$sender])) {
        $event_attendees[count($event_attendees)] = array('email' => $sender,
                                   'attendance' => 'optional',
                                   'responce' => $new_status[$sender]);
    }

    $driver->modifyMeeting($meeting_id, 'attendees', $event_attendees);
    $driver->store();
    return true;
}

function _moment_vevent_from_uid($uid)
{
    global $conf;
    require_once dirname(__FILE__) . '/base.php';
    require_once MOMENT_BASE . '/lib/Storage.php';

    /* Create a driver instance. */
    $driver = &Moment_Driver::singleton();
    $driver->retrieve();

    $meeting_id = $driver->getMeetingIdByUid($uid);
    if (is_a($meeting_id, 'PEAR_Error')) {
        return $meeting_id;
    }

    $meeting = $driver->getMeeting($meeting_id);
    if (is_a($meeting, 'PEAR_Error')) {
        return $meeting;
    }

    $iCal = Moment::iCalRequest($meeting);
    $vEvent = $iCal->getComponent(0);

    return $vEvent;
}
