<?php
/**
 * $Horde: horde/javascript.php,v 1.17 2003/04/11 18:54:00 slusarz Exp $
 *
 * Copyright 2000-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

@define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Registry.php';
require_once HORDE_BASE . '/lib/Browser.php';
 
$browser = &Browser::singleton();
$registry = &Registry::singleton(HORDE_SESSION_READONLY);

// Figure out if we've been inlined, or called directly.
$send_headers = strstr($_SERVER['PHP_SELF'], 'javascript.php');

$app = Horde::getFormData('app');
$file = basename(Horde::getFormData('file'));
if (!empty($app) && !empty($file)) {
    $script_file = $registry->getParam('templates', $app) . '/javascript/' . $file;
    if (@file_exists($script_file)) {
        $registry->pushApp($app);
        $script = Horde::bufferOutput('require', $script_file);

        if ($send_headers) {
            require_once HORDE_BASE . '/lib/Server.php';
            $mod_gmt = gmdate('D, d M Y H:i:s', filemtime($script_file)) . ' GMT';
            header('Last-Modified: ' . $mod_gmt);
            header('Cache-Control: public, max-age=86400');
            header('Content-Type: text/javascript');
            if (Server::HTTPProtocol() != '1.1') {
                header('Content-Length: ' . strlen($script));
            }
        }

        echo $script;
    }
}
