<?php

require_once HORDE_BASE . '/lib/MIME/Viewer/enriched.php';

/**
 * The IMP_MIME_Viewer_enriched class renders out plain text from
 * enriched content tags, ala RFC 1896
 *
 * $Horde: imp/lib/MIME/Viewer/enriched.php,v 1.27 2003/08/06 21:35:55 slusarz Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @version $Revision: 1.27 $
 * @since   IMP 3.1
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_enriched extends MIME_Viewer_enriched {

    /**
     * Render out the currently set contents.
     *
     * @access public
     *
     * @param array $params  An array with a reference to a MIME_Contents
     *                       object.
     *
     * @return string  The rendered text in HTML.
     */
    function render($params)
    {
        $contents = &$params[0];

        global $prefs;

        if (($text = $this->mime_part->getContents()) === false) {
            return $contents->formatPartError(_("There was an error displaying this message part"));
        }

        if (trim($text) == '') {
            return $text;
        }

        $charset = $this->getCharset();

        $text = parent::render();

        // Highlight quoted parts of an email.
        if ($prefs->getValue('highlight_text')) {
            $text = implode("\n", preg_replace('|^(\s*&gt;.+)$|', '<span class="quoted1">\1</span>', explode("\n", $text)));
            $indent = 1;
            while (preg_match('|&gt;(\s?&gt;){' . $indent . '}|', $text)) {
                $text = implode("\n", preg_replace('|^<span class="quoted' . ((($indent - 1) % 5) + 1) . '">(\s*&gt;(\s?&gt;){' . $indent . '}.+)$|', '<span class="quoted' . (($indent % 5) + 1) . '">\1', explode("\n", $text)));
                $indent++;
            }
        }

        // Dim signatures.
        if ($prefs->getValue('dim_signature')) {
            $parts = preg_split('|(\n--\s*\n)|', $text, 2, PREG_SPLIT_DELIM_CAPTURE);
            $text = array_shift($parts);
            if (count($parts)) {
                $text .= '<span class="signature">' . $parts[0];
                $text .= preg_replace('|class="[^"]+"|', 'class="signature-fixed"', $parts[1]);
                $text .= '</span>';
            }
        }

        // Filter bad language.
        $text = IMP::filterText($text);

        /* If the text is in a different character set, and we're not
           already in a new window, give the user a link to open it in
           a new window with the right character set. */
        // NOTE: This could affect RFC compliance if we implement <lang> tags
        if ((NLS::getCharset() != 'UTF-8') &&
            (String::lower($this->mime_part->getCharset()) != String::lower(NLS::getCharset())) &&
            ((String::lower($this->mime_part->getCharset()) != 'us-ascii') &&
              !$contents->viewAsAttachment())) {
            $status = array(
                sprintf(_("This message was written in a character set (%s) other than your own."), htmlspecialchars($this->mime_part->getCharset())),
                sprintf(_("If it is not displayed correctly, %s to open it in a new window."), $contents->linkViewJS($this->mime_part, 'view_attach', _("click here")))
            );
            $text = $contents->formatStatusMsg($status, null, false) . '<p />' . $text;
        }

        return $text;
    }

}
