<?php
/**
 * $Horde: imp/acl.php,v 1.11 2003/08/21 13:21:45 jan Exp $
 *
 * Copyright 2000-2003 Chris Hastie <imp@oak-wood.co.uk>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
$authentication = OP_HALFOPEN;
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/ACL.php';
require_once IMP_BASE . '/lib/Folder.php';

/* Redirect back to the options screen if acl is not
   enabled. */
if ($prefs->isLocked('acl') || !(isset($_SESSION['imp']['acl']) && is_array($_SESSION['imp']['acl']))) {
    $notification->push(_("Folder sharing is not enabled."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('prefs.php', true));
    exit;
}
if (isset($_SESSION['imp']['acl']['params'])) {
    $ACLDriver = IMP_ACL::singleton($_SESSION['imp']['acl']['driver'], $_SESSION['imp']['acl']['params']);
} else {
    $ACLDriver = IMP_ACL::singleton($_SESSION['imp']['acl']['driver']);
}

/* Check selected driver is supported. Redirect to options screen with
   error message if not */
$driverSupported = $ACLDriver->isSupported();
$protected       = $ACLDriver->getProtected();
$folder          = '';

if (!$driverSupported){
    $notification->push(_("This server does not support sharing folders."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('prefs.php', true));
    exit;
}

$ok_form = true;
$acl = Horde::getFormData('acl');

/* Run through the action handlers */
$actionID = Horde::getFormData('actionID');
switch ($actionID) {
case 'imp_acl_set':
    if (!($share_user = Horde::getFormData('share_user'))) {
        $notification->push(_("No user specified."), 'horde.error');
        $ok_form = false;
    }
    if (!($folder = Horde::getFormData('folder'))) {
        $notification->push(_("No folder selected."), 'horde.error');
        $ok_form = false;
    }
    if (in_array($share_user, $protected)) {
        $notification->push(_("Permissions for this user can not be changed."), 'horde.error');
        $ok_form = false;
    }

    if ($ok_form) {
        $result = $ACLDriver->createACL($folder, $share_user, $acl);
        if ($result === 'no_support') {
            header('Location: ' . Horde::applicationUrl('prefs.php', true));
            exit;
        }
    }
    break;

case 'imp_acl_edit':
    if (!($share_user = Horde::getFormData('share_user'))) {
        $notification->push(_("No user specified."), 'horde.error');
        $ok_form = false;
    }
    if (!($folder = Horde::getFormData('folder'))) {
        $notification->push(_("No folder selected."), 'horde.error');
        $ok_form = false;
    }
    if (in_array($share_user, $protected)) {
        $notification->push(_("Permissions for this user can not be changed."), 'horde.error');
        $ok_form = false;
    }

    if ($ok_form) {
        $result = $ACLDriver->editACL($folder, $share_user, $acl);
        if ($result === 'no_support') {
            header('Location: ' . Horde::applicationUrl('prefs.php', true));
            exit;
        }
    }
    break;
}

$imp_folder = &IMP_Folder::singleton();
$rights = $ACLDriver->getRights();

if (empty($folder) && !($folder = Horde::getFormData('folder'))) {
    $folder = 'INBOX';
}

if (count($imp_folder->flist_IMP())) {
    $options = IMP::flistSelect('', true, array(), $folder);
}

$curr_acl = array();
$curr_acl = $ACLDriver->getACL($folder);
$canEdit = $ACLDriver->canEdit($folder, $_SESSION['imp']['user']);

/* Set up javascript arrays. */
if (count($curr_acl)) {
    $js_user = '';
    foreach ($rights as $right => $desc) {
        $js_right[$right] = '';
    }

    foreach ($curr_acl as $curr_user => $granted) {
        if (strlen($js_user) > 0) {
            $js_user .= ', ';
            foreach ($rights as $right => $desc) {
                $js_right[$right] .= ', ';
            }
        }

        $js_user .= '"' . $curr_user . '"';

        foreach ($rights as $right => $desc) {
            if (!empty($granted[$right])) {
                $js_right[$right] .= '"1"';
            } else {
                $js_right[$right] .= '"0"';
            }
        }
    }
}

/* Initialize the PrefsUI code. */
require_once HORDE_BASE . '/lib/PrefsUI.php';
require IMP_BASE . '/config/prefs.php';

$title = _("Share Folders");
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();
require IMP_TEMPLATES . '/acl/javascript.inc';
require IMP_TEMPLATES . '/acl/list.inc';
require IMP_TEMPLATES . '/acl/manage.inc';
require IMP_TEMPLATES . '/common-footer.inc';
