<?php
/*
 * forwards Configuration File
 *
 * This file contains global configuration settings for forwards. Values
 * may be safely edited by hand. Use conf.php.dist as a reference.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be 'true' or 'false'.
 *
 * $Horde: forwards/config/conf.php.dist,v 1.10 2003/07/11 12:28:20 opal Exp $
 */

// The driver to use.  Valid values are:
//
// forwards:         An ftp driven driver for dot-forward compliant mailers.
// qmail:            An ftp driven driver for qmail compliant mailers.
// mdaemon:          An mdaemon mail server driver.
// sql:              An exim mailer based sql driver.
// ldap:	     An exim mailer based ldap driver.

$conf['server']['driver'] = 'kolab';

// Any parameters that the driver needs go in this array.  See driver specific
// sections below for information on what parameters each driver takes...

$conf['server']['params'] = array();

// If not using realms (multiple domains or virtual hosting) then there is
// only one possible configuration which is called 'default' by convention.
// Even if you are using realms/hosting, you should probably set a default
// configuration.  The following line defines the default configuration for
// the 'forwards' ftp based driver, setting the hostname where the ftp server
// is running and the port that it is running one.  These may be overriden
// by realm/domain specific values by defining additional arrays, one per
// realm/domain, with the realm/domain name as the key instead of the key
// 'default' as shown below.

$conf['server']['params']['default'] = array(
    'host' => $conf['server']['name']
);

// If you are using realms or virtual hosting where you authenticate to
// Horde with 'user@realm' rather than just 'user', then you can have
// a seperate configuration for each realm or domain. The following
// example would be for a realm called 'example.com':
//
// $conf['server']['params']['example.com'] =
//     array('host' => 'mail.example.com', 'port' => 21);

// For sql we use usual horde sql settings plus some more:
// $conf['server']['params'] = array();
// $conf['server']['params']['phptype'] = 'mysql';
// $conf['server']['params']['hostspec'] = 'localhost';
// $conf['server']['params']['username'] = 'username';
// $conf['server']['params']['password'] = 'password';
// $conf['server']['params']['altemail'] = 'alternative_email_column_name';
// $conf['server']['params']['forward'] = 'email_forward_y_or_n';
// $conf['server']['params']['database'] = 'database';
// $conf['server']['params']['table'] = 'users_table';
// $conf['server']['params']['user_col'] = 'column_which_contains_usernames';
// $conf['server']['params']['pass_col'] = 'column_with_passwords';


// For ldap we use usual horde sql settings plus some more:
//$conf['server']['params']['default'] = array(
//        'host' => 'ldap.some.org',
//        'uid'=> 'uid',  // The attribute that is searched for the user id.
//        'port' => 389,
//        'basedn' => 'ou=mailaccount,dc=twinspot,dc=net',
//        'userdn' => 'uid=' . Auth::getAuth() . ',ou=mailaccounts,dc=some.org',
//        'forwards' => 'mailforward' // The attribute that defines where the should go.
//);

// Define usernames for which we will refuse to set forwards.  Lists usernames
// only, and be aware that this blocks the username in all realms!

$conf['user']['refused'] = array('root','bin','daemon','adm','lp','shutdown',
     'halt','uucp','ftp','anonymous','nobody','httpd','operator','guest',
     'diginext','bind','courier','cyrus','games','kmem','mailnull','man',
     'mysql','news','postfix','sshd','tty','www');

// Define apps to put in the menu bar.  To include IMP in the menu bar, you
// would add: $conf['menu']['apps'] = array('imp');

$conf['menu']['apps'] = array();
