<?php
/**
 * registry.php -- Horde application registry
 *
 * $Horde: horde/config/registry.php.dist,v 1.174 2003/08/21 23:38:09 chuck Exp $
 *
 * This configuration file is used by Horde to determine which Horde
 * applications are installed and where, as well as how they interact.
 *
 * Application registry
 * --------------------
 * The following settings register installed Horde applications.
 * By default, Horde assumes that the application directories live
 * inside the horde directory.
 *
 * Attribute     Type     Description
 * ---------     ----     -----------
 * fileroot      string   The base filesystem path for the module's files
 * webroot       string   The base URI for the module
 * icon          string   The URI for an icon to show in menus for the module
 * name          string   The name used menus and descriptions for a module
 * allow_guests  boolean  Allow guests, or only logged in users, access?
 * status        string   'inactive', 'hidden', 'notoolbar', 'heading' or
 *                        'active'.
 * provides      string   Service types the module provides.
 * initial_page  string   The initial (default) page (filename) for the module
 * templates     string   The filesystem path to the templates directory
 * menu_parent   string   The name of the 'heading' group that this app should
 *                        show up under.
 * target        string   The (optional) target frame for the link.
 */

$this->applications['horde'] = array(
    'fileroot' => dirname(__FILE__) . '/..',
    'webroot' => '/horde',
    'initial_page' => 'login.php',
    'icon' => '/horde/graphics/horde.gif',
    'name' => _("Portal"),
    'allow_guests' => true,
    'status' => 'active',
    'templates' => dirname(__FILE__) . '/../templates',
    'provides' => 'horde'
);

$this->applications['logout'] = array(
    'fileroot' => dirname(__FILE__) . '/..',
    'webroot' => $this->applications['horde']['webroot'],
    'initial_page' => 'login.php?reason=logout',
    'icon' => $this->applications['horde']['webroot'] . '/graphics/logout.gif',
    'name' => _("Logout"),
    'allow_guests' => false,
    'status' => 'notoolbar'
);

$this->applications['imp'] = array(
    'fileroot' => dirname(__FILE__) . '/../imp',
    'webroot' => $this->applications['horde']['webroot'] . '/imp',
    'icon' => $this->applications['horde']['webroot'] . '/imp/graphics/imp.gif',
    'name' => _("Mail"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => 'mail'
);

$this->applications['turba'] = array(
    'fileroot' => dirname(__FILE__) . '/../turba',
    'webroot' => $this->applications['horde']['webroot'] . '/turba',
    'icon' => $this->applications['horde']['webroot'] . '/turba/graphics/turba.gif',
    'name' => _("Address Book"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => array('contacts', 'clients')
);

$this->applications['moment'] = array(
    'fileroot' => dirname(__FILE__) . '/../moment',
    'webroot' => $this->applications['horde']['webroot'] . '/moment',
    'icon' => $this->applications['horde']['webroot'] . '/moment/graphics/moment.gif',
    'name' => _("Meetings"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => array('meeting', 'calendar/import_vfreebusy')
);

$this->applications['kronolith'] = array(
    'fileroot' => dirname(__FILE__) . '/../kronolith',
    'webroot' => $this->applications['horde']['webroot'] . '/kronolith',
    'icon' => $this->applications['horde']['webroot'] . '/kronolith/graphics/kronolith.gif',
    'name' => _("Calendar"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => 'calendar'
);

$this->applications['mnemo'] = array(
    'fileroot' => dirname(__FILE__) . '/../mnemo',
    'webroot' => $this->applications['horde']['webroot'] . '/mnemo',
    'icon' => $this->applications['horde']['webroot'] . '/mnemo/graphics/mnemo.gif',
    'name' => _("Notes"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => 'notes'
);

$this->applications['nag'] = array(
    'fileroot' => dirname(__FILE__) . '/../nag',
    'webroot' => $this->applications['horde']['webroot'] . '/nag',
    'icon' => $this->applications['horde']['webroot'] . '/nag/graphics/nag.gif',
    'name' => _("Tasks"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => 'tasks',
    'links' => array(
        'follow-up-to' => array(
            'provider' => 'tasks',
            'description' => _("Follow up task"),
            'reverse' => array(
                'description'=> _("Previous task"),
                'type' => 'follow-up-from',
                'readonly' => true,
                ),
            ),
        'client' => array(
            'provider' => 'contacts',
            'description' => _("Client"),
            'reverse' => array(
                'description' => _("Task"),
                'type' => 'task',
                'readonly' => false,
                ),
            ),
        )
);

$this->applications['myaccount'] = array(
    'icon' => $this->applications['horde']['webroot'] . '/graphics/myaccount.gif',
    'name' => _("Account Settings"),
    'status' => 'heading',
);

$this->applications['forwards'] = array(
    'fileroot' => dirname(__FILE__) . '/../forwards',
    'webroot' => $this->applications['horde']['webroot'] . '/forwards',
    'icon' => $this->applications['horde']['webroot'] . '/forwards/graphics/forwards.gif',
    'name' => _("Forwarding"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => 'forwards',
    'menu_parent' => 'myaccount'
);

$this->applications['passwd'] = array(
    'fileroot' => dirname(__FILE__) . '/../passwd',
    'webroot' => $this->applications['horde']['webroot'] . '/passwd',
    'icon' => $this->applications['horde']['webroot'] . '/passwd/graphics/passwd.gif',
    'name' => _("Password"),
    'allow_guests' => false,
    'status' => 'active',
    'menu_parent' => 'myaccount'
);

$this->applications['vacation'] = array(
    'fileroot' => dirname(__FILE__) . '/../vacation',
    'webroot' => $this->applications['horde']['webroot'] . '/vacation',
    'icon' => $this->applications['horde']['webroot'] . '/vacation/graphics/vacation.gif',
    'name' => _("Vacation"),
    'allow_guests' => false,
    'status' => 'active',
    'provides' => 'vacation',
    'menu_parent' => 'myaccount'
);
