/*
    This file is part of KOrganizer.
    Copyright (c) 2002, Klaralvdalens Datakonsult AB <info@klaralvdalens-datakonsult.se>

    Author: Steffen Hansen <steffen@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KOTODOEDITORDETAILS_H
#define KOTODOEDITORDETAILS_H

#include "kotodoeditordetails_base.h"

namespace KCal { class Attendee; };
namespace KCal { class Incidence; };

class KOTodoEditorDetails : public KOTodoEditorDetails_base {
  Q_OBJECT
public:
  KOTodoEditorDetails( int spacing, QWidget* parent = 0, const char* name = 0 );

  /** Read event object and setup widgets accordingly */
  void readEvent(KCal::Incidence *, bool);
  /** Write event settings to event object */
  void writeEvent(KCal::Incidence *);

  bool validateInput();

protected slots:
  void updateAttendeeItem();
  void openAddressBook();
private:
  KCal::Attendee *mAssignee;
};

#endif // KOTODOEDITORDETAILS_H
