/*
    This file is part of KOrganizer.
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef _KOEDITORDETAILS_H
#define _KOEDITORDETAILS_H

#include <qlineedit.h>
#include <qptrlist.h>

#include <kapplication.h>

#include <libkcal/event.h>

#include <kdgantt/KDGanttView.h>

#include "ktimeedit.h"
#include "customlistviewitem.h"

class KDateEdit;
class KOEventTimeWidget;
class KOLineEdit;
class QCheckBox;
class QLabel;
class QPushButton;

using namespace KCal;

namespace KCal {
  class FreeBusy;
};

class AttendeeListItem;

class KOEditorDetails : public QWidget
{
    Q_OBJECT
  public:
    KOEditorDetails (bool showDatetime, int spacing = 8,QWidget* parent = 0, const char* name = 0);
    virtual ~KOEditorDetails();

    /** Set widgets to default values */
    void setDefaults(QDateTime from,QDateTime to,bool allDay);
    /** Read event object and setup widgets accordingly */
    void readEvent(Incidence *, bool);
    /** Write event settings to event object */
    void writeEvent(Incidence *);

    /** return a clone of the event with attendees to be canceld*/
    void cancelAttendeeEvent(Incidence *);
    /** Check if the input is valid. */
    bool validateInput();
    void insertMyself();

    KOEventTimeWidget* eventTimeWidget() const { return mEventTimeWidget; }

  public slots:
    void insertAttendee(Attendee *);
    void slotUpdateGanttView( QDateTime, QDateTime );

    void slotInsertFreeBusy( const QString& email, FreeBusy* fb );

  protected slots:
    void addNewAttendee();
    void removeAttendee();
    void openAddressBook();
    void updateAttendeeInput();
    void clearAttendeeInput();
    void fillAttendeeInput(AttendeeListItem *);
    void updateAttendeeItem();
    void setEnabledAttendeeInput(bool);
    void updateFreeBusyData();
    void slotScaleChanged( int );
    void slothFormatChanged( int );
    void slotCenterOnStart() ;
    void slotZoomToTime();
    void slotPickDate();

  private:
    bool findFreeSlot( QDateTime& dtFrom, QDateTime& dtTo );
    bool tryDate( QDateTime& tryFrom, QDateTime& tryTo );
    bool tryDate( AttendeeListItem* attendee,
                  QDateTime& tryFrom, QDateTime& tryTo );
    void updateStatusSummary();

    bool mDisableItemUpdate;

    KOEventTimeWidget* mEventTimeWidget;
    KOLineEdit *mNameEdit;
    QLineEdit *mUidEdit;
    QLineEdit *mEmailEdit;
    QListView *mListView;
    KDGanttView *mGanttView;
    QComboBox* mRoleCombo;
    QCheckBox* mRsvpButton;
    QComboBox* mStatusCombo;
    QLabel *mOrganizerLabel;
    QLabel *mStatusSummaryLabel;

    QPushButton* mAddButton;
    QPushButton* mRemoveButton;
    QPushButton* mAddressBookButton;
    QComboBox* scaleCombo;
    QPtrList<Attendee> mdelAttendees;

    bool mIsOrganizer;
};


class KOFocusOutLineEdit : public QLineEdit
{
    Q_OBJECT

public:
    KOFocusOutLineEdit( QWidget* parent = 0, const char* name = 0 ) :
        QLineEdit( parent, name ) {}

signals:
    void focusLost();

protected:
    void focusOutEvent( QFocusEvent* e ) {
        emit focusLost();
        QLineEdit::focusOutEvent( e );
    }
};


#endif
