/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.event;

import java.awt.BDJHelper;
import java.util.Iterator;
import java.util.LinkedList;
import org.davic.resources.ResourceClient;
import org.davic.resources.ResourceServer;
import org.davic.resources.ResourceStatusEvent;
import org.davic.resources.ResourceStatusListener;
import org.dvb.event.UserEvent;
import org.dvb.event.UserEventAvailableEvent;
import org.dvb.event.UserEventListener;
import org.dvb.event.UserEventRepository;
import org.dvb.event.UserEventUnavailableEvent;
import org.videolan.BDJAction;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public class EventManager
implements ResourceServer {
    private static final Object instanceLock = new Object();
    private LinkedList exclusiveUserEventListener = new LinkedList();
    private LinkedList sharedUserEventListener = new LinkedList();
    private LinkedList exclusiveAWTEventListener = new LinkedList();
    private LinkedList resourceStatusEventListeners = new LinkedList();
    private static EventManager instance = null;
    private static final Logger logger = Logger.getLogger(EventManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventManager getInstance() {
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new EventManager();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        EventManager e;
        Object object = instanceLock;
        synchronized (object) {
            e = instance;
            instance = null;
        }
        if (e != null) {
            e.exclusiveUserEventListener.clear();
            e.sharedUserEventListener.clear();
            e.exclusiveAWTEventListener.clear();
            e.resourceStatusEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUserEventListener(UserEventListener listener, ResourceClient client, UserEventRepository userEvents) throws IllegalArgumentException {
        if (client == null) {
            throw new IllegalArgumentException();
        }
        BDJXletContext context = BDJXletContext.getCurrentContext();
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (!this.cleanupReservedEvents(userEvents)) {
                return false;
            }
            this.exclusiveUserEventListener.add(new UserEventItem(context, listener, client, userEvents));
            this.sendResourceStatusEvent(new UserEventUnavailableEvent(userEvents));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserEventListener(UserEventListener listener, UserEventRepository userEvents) {
        if (listener == null || userEvents == null) {
            throw new NullPointerException();
        }
        BDJXletContext context = BDJXletContext.getCurrentContext();
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.sharedUserEventListener.add(new UserEventItem(context, listener, null, userEvents));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserEventListener(UserEventListener listener) {
        BDJXletContext context = BDJXletContext.getCurrentContext();
        EventManager eventManager = this;
        synchronized (eventManager) {
            UserEventItem item;
            Iterator it = this.sharedUserEventListener.iterator();
            while (it.hasNext()) {
                item = (UserEventItem)it.next();
                if (item.context != context || item.listener != listener) continue;
                it.remove();
            }
            it = this.exclusiveUserEventListener.iterator();
            while (it.hasNext()) {
                item = (UserEventItem)it.next();
                if (item.context != context || item.listener != listener) continue;
                this.sendResourceStatusEvent(new UserEventAvailableEvent(item.userEvents));
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addExclusiveAccessToAWTEvent(ResourceClient client, UserEventRepository userEvents) throws IllegalArgumentException {
        if (client == null) {
            throw new IllegalArgumentException();
        }
        BDJXletContext context = BDJXletContext.getCurrentContext();
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (!this.cleanupReservedEvents(userEvents)) {
                return false;
            }
            this.exclusiveAWTEventListener.add(new UserEventItem(context, null, client, userEvents));
            this.sendResourceStatusEvent(new UserEventUnavailableEvent(userEvents));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusiveAccessToAWTEvent(ResourceClient client) {
        BDJXletContext context = BDJXletContext.getCurrentContext();
        EventManager eventManager = this;
        synchronized (eventManager) {
            Iterator it = this.exclusiveAWTEventListener.iterator();
            while (it.hasNext()) {
                UserEventItem item = (UserEventItem)it.next();
                if (item.context != context || item.client != client) continue;
                this.sendResourceStatusEvent(new UserEventAvailableEvent(item.userEvents));
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceStatusEventListener(ResourceStatusListener listener) {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.resourceStatusEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceStatusEventListener(ResourceStatusListener listener) {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.resourceStatusEventListeners.remove(listener);
        }
    }

    private void sendResourceStatusEvent(ResourceStatusEvent event) {
        Iterator it = this.resourceStatusEventListeners.iterator();
        while (it.hasNext()) {
            ((ResourceStatusListener)it.next()).statusChanged(event);
        }
    }

    public void receiveKeyEvent(int type, int modifiers, int keyCode) {
        this.receiveKeyEventN(type, modifiers, keyCode);
    }

    public boolean receiveKeyEventN(int type, int modifiers, int keyCode) {
        UserEventItem item;
        Iterator it;
        UserEvent ue = new UserEvent(this, 1, type, keyCode, modifiers, System.currentTimeMillis());
        BDJXletContext context = BDJXletContext.getFocusContext();
        boolean result = false;
        if (context != null) {
            it = this.exclusiveAWTEventListener.iterator();
            while (it.hasNext()) {
                item = (UserEventItem)it.next();
                if (item.context == null || item.context.isReleased()) {
                    logger.error("Removing exclusive AWT event listener for " + item.context);
                    it.remove();
                    continue;
                }
                if (item.context != context || !item.userEvents.contains(ue)) continue;
                result = BDJHelper.postKeyEvent((int)type, (int)modifiers, (int)keyCode);
                logger.info("Key posted to exclusive AWT event listener, r=" + result);
                return true;
            }
        } else {
            logger.info("No focused HScene found !");
        }
        it = this.exclusiveUserEventListener.iterator();
        while (it.hasNext()) {
            item = (UserEventItem)it.next();
            if (item.context == null || item.context.isReleased()) {
                logger.error("Removing exclusive UserEvent listener for " + item.context);
                it.remove();
                continue;
            }
            if (!item.userEvents.contains(ue)) continue;
            item.context.putUserEvent(new UserEventAction(item, ue));
            logger.info("Key posted to exclusive UE listener");
            return true;
        }
        result = BDJHelper.postKeyEvent((int)type, (int)modifiers, (int)keyCode);
        it = this.sharedUserEventListener.iterator();
        while (it.hasNext()) {
            item = (UserEventItem)it.next();
            if (item.context == null || item.context.isReleased()) {
                logger.error("Removing UserEvent listener for " + item.context);
                it.remove();
                continue;
            }
            if (!item.userEvents.contains(ue)) continue;
            item.context.putUserEvent(new UserEventAction(item, ue));
            logger.info("Key posted to shared UE listener");
            result = true;
        }
        return result;
    }

    private boolean cleanupReservedEvents(UserEventRepository userEvents) {
        UserEventItem item;
        BDJXletContext context = BDJXletContext.getCurrentContext();
        Iterator it = this.exclusiveUserEventListener.iterator();
        while (it.hasNext()) {
            item = (UserEventItem)it.next();
            if (item.context == context || !this.hasOverlap(userEvents, item.userEvents)) continue;
            try {
                if (!item.client.requestRelease(item.userEvents, null)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.error("requestRelease() failed: " + e.getClass());
                e.printStackTrace();
                return false;
            }
            this.sendResourceStatusEvent(new UserEventAvailableEvent(item.userEvents));
            it.remove();
        }
        it = this.exclusiveAWTEventListener.iterator();
        while (it.hasNext()) {
            item = (UserEventItem)it.next();
            if (item.context == context || !this.hasOverlap(userEvents, item.userEvents)) continue;
            try {
                if (!item.client.requestRelease(item.userEvents, null)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.error("requestRelease() failed: " + e.getClass());
                e.printStackTrace();
                return false;
            }
            this.sendResourceStatusEvent(new UserEventAvailableEvent(item.userEvents));
            it.remove();
        }
        return true;
    }

    private boolean hasOverlap(UserEventRepository userEvents1, UserEventRepository userEvents2) {
        UserEvent[] evts1 = userEvents1.getUserEvent();
        UserEvent[] evts2 = userEvents2.getUserEvent();
        for (int i = 0; i < evts1.length; ++i) {
            UserEvent evt1 = evts1[i];
            for (int j = 0; j < evts2.length; ++j) {
                UserEvent evt2 = evts2[j];
                if (evt1.getFamily() != evt2.getFamily() || evt1.getCode() == evt2.getCode()) continue;
                return true;
            }
        }
        return false;
    }

    private static class UserEventAction
    extends BDJAction {
        private UserEventListener listener;
        private UserEvent event;

        public UserEventAction(UserEventItem item, UserEvent event) {
            this.listener = item.listener;
            this.event = event;
        }

        protected void doAction() {
            this.listener.userEventReceived(this.event);
        }
    }

    private static class UserEventItem {
        public final BDJXletContext context;
        public final UserEventListener listener;
        public final ResourceClient client;
        public final UserEventRepository userEvents;

        public UserEventItem(BDJXletContext context, UserEventListener listener, ResourceClient client, UserEventRepository userEvents) {
            this.context = context;
            this.listener = listener;
            this.client = client;
            this.userEvents = userEvents.getNewInstance();
            if (context == null) {
                logger.error("Missing xlet context: " + Logger.dumpStack());
            }
        }
    }
}

