/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmpovrayoutputwidget.h"

#include <QTextEdit>
#include <qlayout.h>
//Added by qt3to4:
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QResizeEvent>

#include <klocale.h>
#include <kglobalsettings.h>
#include <kconfig.h>
#include <kpushbutton.h>
#include <KStandardGuiItem>

#include "pmdebug.h"

QSize PMPovrayOutputWidget::s_size = QSize( 400, 400 );

PMPovrayOutputWidget::PMPovrayOutputWidget( QWidget* parent )
      : KDialog( parent )
{
	m_pTextView = new QTextEdit( this );
   m_pTextView->setFont( KGlobalSettings::fixedFont( ) );
   m_pTextView->setReadOnly( true );
   setMainWidget( m_pTextView );

	connect( this, SIGNAL( closeClicked( ) ), SLOT( slotClose( ) ) );
	setButtons( KDialog::Close );

   setCaption( i18n( "Povray Output" ) );
   resize( s_size );

   m_startOfLastLine = 0;
}

PMPovrayOutputWidget::~PMPovrayOutputWidget( )
{
}

void PMPovrayOutputWidget::slotClear( )
{
   m_output = QString::null;
   m_startOfLastLine = 0;
   m_pTextView->clear( );
}

void PMPovrayOutputWidget::slotText( const QString& output )
{
   int i;

   for( i = 0; i < output.length( ); i++ )
   {
      QChar c = output[i];
      if( c == '\r' )
         m_output.truncate( m_startOfLastLine );
      else if( c == '\n' )
      {
         m_output += c;
         m_startOfLastLine = m_output.length( );
         //kDebug( PMArea ) << m_startOfLastLine;
      }
      else if( c.isPrint( ) )
         m_output += c;
   }

   m_pTextView->setPlainText( m_output );
}

void PMPovrayOutputWidget::slotClose( )
{
   hide( );
}


void PMPovrayOutputWidget::saveConfig( KConfig* cfg )
{
   KConfigGroup cfgcg( cfg, "Appearance" );
   cfgcg.writeEntry( "PovrayOutputWidgetSize", s_size );
}

void PMPovrayOutputWidget::restoreConfig( KConfig* cfg )
{
   KConfigGroup cfgcg( cfg, "Appearance" );

   QSize defaultSize( 500, 400 );
   s_size = cfgcg.readEntry<QSize>( "PovrayOutputWidgetSize", defaultSize );
}

void PMPovrayOutputWidget::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}

#include "pmpovrayoutputwidget.moc"
