/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2007 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pminserterrordialog.h"
#include <klocale.h>
#include <QLabel>
#include <QListWidget>
#include <kvbox.h>

PMInsertErrorDialog::PMInsertErrorDialog(
   int numObj, int numErrors,
   const QStringList& details,
   QWidget* parent /*= 0 */ )
      : KDialog( parent )
{
	setCaption( i18n( "Insert Errors" ) );
	setButtons( Help | Ok | User1 );
	setDefaultButton( Ok );
	setButtonText( User1, i18n( "Details" ) );
   KVBox* page = new KVBox( this );
   setMainWidget( page );
   new QLabel( i18np( "%2 of 1 object could not be inserted.", "%2 of %1 objects could not be inserted.",
                 numObj, numErrors ), page );

   m_pDetailsLabel = new QLabel( i18n( "Objects not inserted:" ), page );
   m_pDetailsLabel->hide( );

   m_pDetails = new QListWidget( page );
   m_pDetails->addItems( details );
   m_pDetails->setMinimumHeight( 150 );
   m_pDetails->hide( );
   connect(this,SIGNAL(user1Clicked()),this,SLOT(slotUser1( )));

}

void PMInsertErrorDialog::slotUser1( )
{
   m_pDetailsLabel->show( );
   m_pDetails->show( );
}
#include "pminserterrordialog.moc"
