/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.c14n.helpers.C14nHelper;
import org.apache.axiom.c14n.impl.CanonicalizerBase;
import org.apache.axiom.c14n.impl.NameSpaceSymbTable;
import org.apache.axiom.c14n.omwrapper.interfaces.Attr;
import org.apache.axiom.c14n.omwrapper.interfaces.Element;
import org.apache.axiom.c14n.omwrapper.interfaces.NamedNodeMap;
import org.apache.axiom.c14n.omwrapper.interfaces.Node;

public abstract class Canonicalizer20010315
extends CanonicalizerBase {
    boolean firstCall = true;
    final SortedSet result = new TreeSet(COMPARE);
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer20010315(boolean includeComments) {
        super(includeComments);
    }

    Iterator handleAttributesSubtree(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        if (!E.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet result = this.result;
        result.clear();
        NamedNodeMap attrs = E.getAttributes();
        int attrsLength = attrs.getLength();
        for (int i = 0; i < attrsLength; ++i) {
            Node n;
            Attr N = (Attr)attrs.item(i);
            String NUri = N.getNamespaceURI();
            if (XMLNS_URI != NUri) {
                result.add(N);
                continue;
            }
            String NName = N.getLocalName();
            String NValue = N.getValue();
            if ("xml".equals(NName) && XML_LANG_URI.equals(NValue) || (n = ns.addMappingAndRender(NName, NValue, N)) == null) continue;
            result.add(n);
            if (!C14nHelper.namespaceIsRelative(N)) continue;
            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
        if (this.firstCall) {
            ns.getUnrenderedNodes(result);
            this.xmlattrStack.getXmlnsAttr(result);
            this.firstCall = false;
        }
        return result.iterator();
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces) throws CanonicalizationException {
        throw new CanonicalizationException("All Namespaces are Included by Default");
    }

    void handleParent(Element e, NameSpaceSymbTable ns) {
        if (!e.hasAttributes()) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap attrs = e.getAttributes();
        int attrsLength = attrs.getLength();
        for (int i = 0; i < attrsLength; ++i) {
            Attr N = (Attr)attrs.item(i);
            if (XMLNS_URI != N.getNamespaceURI()) {
                if (XML_LANG_URI != N.getNamespaceURI()) continue;
                this.xmlattrStack.addXmlnsAttr(N);
                continue;
            }
            String NName = N.getLocalName();
            String NValue = N.getNodeValue();
            if ("xml".equals(NName) && XML_LANG_URI.equals(NValue)) continue;
            ns.addMapping(NName, NValue, N);
        }
    }

    static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List levels = new ArrayList();

        XmlAttrStack() {
        }

        void push(int level) {
            this.currentLevel = level;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel > this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                if (this.levels.size() == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = ((XmlsStackElement)this.levels.get((int)(this.levels.size() - 1))).level;
            }
        }

        void addXmlnsAttr(Attr n) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(n);
        }

        void getXmlnsAttr(Collection col) {
            int size = this.levels.size() - 1;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            boolean parentRendered = false;
            XmlsStackElement e = null;
            if (size == -1) {
                parentRendered = true;
            } else {
                e = (XmlsStackElement)this.levels.get(size);
                if (e.rendered && e.level + 1 == this.currentLevel) {
                    parentRendered = true;
                }
            }
            if (parentRendered) {
                col.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Attr> loa = new HashMap<String, Attr>();
            while (size >= 0) {
                e = (XmlsStackElement)this.levels.get(size);
                for (Attr n : e.nodes) {
                    if (loa.containsKey(n.getName())) continue;
                    loa.put(n.getName(), n);
                }
                --size;
            }
            this.cur.rendered = true;
            col.addAll(loa.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List nodes = new ArrayList();

            XmlsStackElement() {
            }
        }
    }
}

