/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.impl;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.c14n.helpers.C14nHelper;
import org.apache.axiom.c14n.impl.CanonicalizerBase;
import org.apache.axiom.c14n.impl.NameSpaceSymbTable;
import org.apache.axiom.c14n.omwrapper.interfaces.Attr;
import org.apache.axiom.c14n.omwrapper.interfaces.Element;
import org.apache.axiom.c14n.omwrapper.interfaces.NamedNodeMap;
import org.apache.axiom.c14n.omwrapper.interfaces.Node;

public abstract class Canonicalizer20010315Excl
extends CanonicalizerBase {
    TreeSet _inclusiveNSSet = new TreeSet();
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    final SortedSet result = new TreeSet(COMPARE);

    public Canonicalizer20010315Excl(boolean includeComments) {
        super(includeComments);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, "", null);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, inclusiveNamespaces, null);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces, Node excl) throws CanonicalizationException {
        this._inclusiveNSSet = (TreeSet)Canonicalizer20010315Excl.prefixStr2Set(inclusiveNamespaces);
        return super.engineCanonicalizeSubTree(rootNode, excl);
    }

    Iterator handleAttributesSubtree(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        String prefix;
        SortedSet result = this.result;
        result.clear();
        NamedNodeMap attrs = null;
        int attrsLength = 0;
        if (E.hasAttributes()) {
            attrs = E.getAttributes();
            attrsLength = attrs.getLength();
        }
        SortedSet visiblyUtilized = (SortedSet)this._inclusiveNSSet.clone();
        for (int i = 0; i < attrsLength; ++i) {
            String NNodeValue;
            Attr N = (Attr)attrs.item(i);
            if (XMLNS_URI != N.getNamespaceURI()) {
                String prefix2 = N.getPrefix();
                if (prefix2 != null && !prefix2.equals("xml") && !prefix2.equals("xmlns")) {
                    visiblyUtilized.add(prefix2);
                }
                result.add(N);
                continue;
            }
            String NName = N.getLocalName();
            if (!ns.addMapping(NName, NNodeValue = N.getNodeValue(), N) || !C14nHelper.namespaceIsRelative(NNodeValue)) continue;
            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
        if (E.getNamespaceURI() != null) {
            prefix = E.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = "xmlns";
            }
        } else {
            prefix = "xmlns";
        }
        visiblyUtilized.add(prefix);
        for (String s : visiblyUtilized) {
            Attr key = ns.getMapping(s);
            if (key == null) continue;
            result.add(key);
        }
        return result.iterator();
    }

    public static SortedSet prefixStr2Set(String inclusiveNamespaces) {
        TreeSet<String> prefixes = new TreeSet<String>();
        if (inclusiveNamespaces == null || inclusiveNamespaces.length() == 0) {
            return prefixes;
        }
        StringTokenizer st = new StringTokenizer(inclusiveNamespaces, " \t\r\n");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            if (prefix.equals("#default")) {
                prefixes.add("xmlns");
                continue;
            }
            prefixes.add(prefix);
        }
        return prefixes;
    }
}

