/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.ArrayList;
import java.util.List;
import javax.activation.MimeType;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Text;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.abdera.util.Constants;
import org.apache.axiom.fom.AbderaCollection;
import org.apache.axiom.fom.AbderaWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMWorkspace
extends FOMExtensibleElement
implements AbderaWorkspace {
    public String getTitle() {
        Text title = (Text)this.getFirstChild(Constants.TITLE);
        return title != null ? title.getValue() : null;
    }

    private Text setTitle(String title, Text.Type type) {
        Text text = this.getFactory().newText(Constants.PREFIXED_TITLE, type);
        text.setValue(title);
        this._setChild(Constants.PREFIXED_TITLE, (Element)text);
        return text;
    }

    public Text setTitle(String title) {
        return this.setTitle(title, Text.Type.TEXT);
    }

    public Text setTitleAsHtml(String title) {
        return this.setTitle(title, Text.Type.HTML);
    }

    public Text setTitleAsXHtml(String title) {
        return this.setTitle(title, Text.Type.XHTML);
    }

    public Text getTitleElement() {
        return (Text)this.getFirstChild(Constants.TITLE);
    }

    public List<Collection> getCollections() {
        List<Collection> list = this._getChildrenAsSet(Constants.COLLECTION);
        if (list == null || list.size() == 0) {
            list = this._getChildrenAsSet(Constants.PRE_RFC_COLLECTION);
        }
        return list;
    }

    public Collection getCollection(String title) {
        List<Collection> cols = this.getCollections();
        Collection col = null;
        for (Collection c : cols) {
            if (!c.getTitle().equals(title)) continue;
            col = c;
            break;
        }
        return col;
    }

    public Workspace addCollection(Collection collection) {
        this._addChild((AbderaCollection)collection);
        return this;
    }

    public Collection addCollection(String title, String href) {
        Collection collection = this.getFactory().newCollection((Element)this);
        collection.setTitle(title);
        collection.setHref(href);
        return collection;
    }

    public Collection addMultipartCollection(String title, String href) {
        Collection collection = ((FOMFactory)this.getFactory()).newMultipartCollection(this);
        collection.setTitle(title);
        collection.setHref(href);
        return collection;
    }

    public Collection getCollectionThatAccepts(MimeType ... types) {
        Collection collection = null;
        for (Collection coll : this.getCollections()) {
            int matches = 0;
            MimeType[] mimeTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                MimeType type = mimeTypeArray[n2];
                if (coll.accepts(type)) {
                    ++matches;
                }
                ++n2;
            }
            if (matches != types.length) continue;
            collection = coll;
            break;
        }
        return collection;
    }

    public Collection getCollectionThatAccepts(String ... types) {
        Collection collection = null;
        for (Collection coll : this.getCollections()) {
            int matches = 0;
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (coll.accepts(type)) {
                    ++matches;
                }
                ++n2;
            }
            if (matches != types.length) continue;
            collection = coll;
            break;
        }
        return collection;
    }

    public List<Collection> getCollectionsThatAccept(MimeType ... types) {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (Collection coll : this.getCollections()) {
            int matches = 0;
            MimeType[] mimeTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                MimeType type = mimeTypeArray[n2];
                if (coll.accepts(type)) {
                    ++matches;
                }
                ++n2;
            }
            if (matches != types.length) continue;
            collections.add(coll);
        }
        return collections;
    }

    public List<Collection> getCollectionsThatAccept(String ... types) {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (Collection coll : this.getCollections()) {
            int matches = 0;
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (coll.accepts(type)) {
                    ++matches;
                }
                ++n2;
            }
            if (matches != types.length) continue;
            collections.add(coll);
        }
        return collections;
    }
}

