/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.AbstractCspHeaderItem;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.NoHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CircularDependencyException;
import org.apache.wicket.resource.bundles.ReplacementResourceBundleReference;
import org.apache.wicket.util.lang.Classes;

public class ResourceAggregator
extends DecoratingHeaderResponse {
    private final Map<HeaderItem, RecordedHeaderItem> itemsToBeRendered = new LinkedHashMap<HeaderItem, RecordedHeaderItem>();
    private final List<HeaderItem> domReadyItemsToBeRendered = new ArrayList<HeaderItem>();
    private final List<OnLoadHeaderItem> loadItemsToBeRendered = new ArrayList<OnLoadHeaderItem>();
    private Component renderBase;
    private int indexInRequest;

    public ResourceAggregator(IHeaderResponse real) {
        super(real);
    }

    @Override
    public boolean wasRendered(Object object) {
        boolean ret = super.wasRendered(object);
        if (!ret && object instanceof Component) {
            this.renderBase = (Component)object;
        }
        return ret;
    }

    @Override
    public void markRendered(Object object) {
        super.markRendered(object);
        if (object instanceof Component) {
            this.renderBase = null;
        }
    }

    private void recordHeaderItem(HeaderItem item, Set<HeaderItem> depsDone) {
        this.renderDependencies(item, depsDone);
        RecordedHeaderItem recordedItem = this.itemsToBeRendered.get(item);
        if (recordedItem == null) {
            recordedItem = new RecordedHeaderItem(item);
            this.itemsToBeRendered.put(item, recordedItem);
        }
        recordedItem.addLocation(this.renderBase, this.indexInRequest);
        ++this.indexInRequest;
    }

    private void renderDependencies(HeaderItem item, Set<HeaderItem> depsDone) {
        for (HeaderItem curDependency : item.getDependencies()) {
            if (!depsDone.add(curDependency = this.getItemToBeRendered(curDependency))) {
                throw new CircularDependencyException(depsDone, curDependency);
            }
            this.recordHeaderItem(curDependency, depsDone);
            depsDone.remove(curDependency);
        }
    }

    @Override
    public void render(HeaderItem item) {
        if ((item = this.getItemToBeRendered(item)) instanceof OnDomReadyHeaderItem || item instanceof OnEventHeaderItem) {
            this.renderDependencies(item, new LinkedHashSet<HeaderItem>());
            this.domReadyItemsToBeRendered.add(item);
        } else if (item instanceof OnLoadHeaderItem) {
            this.renderDependencies(item, new LinkedHashSet<HeaderItem>());
            this.loadItemsToBeRendered.add((OnLoadHeaderItem)item);
        } else {
            LinkedHashSet<HeaderItem> depsDone = new LinkedHashSet<HeaderItem>();
            depsDone.add(item);
            this.recordHeaderItem(item, depsDone);
        }
    }

    @Override
    public void close() {
        this.renderHeaderItems();
        if (RequestCycle.get().find(IPartialPageRequestHandler.class).isPresent()) {
            this.renderSeparateEventScripts();
        } else {
            this.renderCombinedEventScripts();
        }
        super.close();
    }

    private void renderHeaderItems() {
        ArrayList<RecordedHeaderItem> sortedItemsToBeRendered = new ArrayList<RecordedHeaderItem>(this.itemsToBeRendered.values());
        Comparator<? super RecordedHeaderItem> headerItemComparator = Application.get().getResourceSettings().getHeaderItemComparator();
        if (headerItemComparator != null) {
            Collections.sort(sortedItemsToBeRendered, headerItemComparator);
        }
        for (RecordedHeaderItem curRenderItem : sortedItemsToBeRendered) {
            if (!this.markItemRendered(curRenderItem.getItem())) continue;
            this.getRealResponse().render(curRenderItem.getItem());
        }
    }

    private void renderCombinedEventScripts() {
        int domReadyLength = this.domReadyItemsToBeRendered.size() * 256;
        StringBuilder domReadScript = new StringBuilder(domReadyLength);
        for (HeaderItem curItem : this.domReadyItemsToBeRendered) {
            if (!this.markItemRendered(curItem)) continue;
            domReadScript.append('\n');
            if (curItem instanceof OnDomReadyHeaderItem) {
                domReadScript.append(((OnDomReadyHeaderItem)curItem).getJavaScript());
            } else if (curItem instanceof OnEventHeaderItem) {
                domReadScript.append(((OnEventHeaderItem)curItem).getCompleteJavaScript());
            }
            domReadScript.append(';');
        }
        if (domReadScript.length() > 0) {
            domReadScript.append("\nWicket.Event.publish(Wicket.Event.Topic.AJAX_HANDLERS_BOUND);\n");
            this.getRealResponse().render(OnDomReadyHeaderItem.forScript(domReadScript));
        }
        int onLoadLength = this.loadItemsToBeRendered.size() * 256;
        StringBuilder onLoadScript = new StringBuilder(onLoadLength);
        for (OnLoadHeaderItem curItem : this.loadItemsToBeRendered) {
            if (!this.markItemRendered(curItem)) continue;
            onLoadScript.append('\n');
            onLoadScript.append(curItem.getJavaScript());
            onLoadScript.append(';');
        }
        if (onLoadScript.length() > 0) {
            this.getRealResponse().render(OnLoadHeaderItem.forScript(onLoadScript.append('\n')));
        }
    }

    private void renderSeparateEventScripts() {
        for (HeaderItem headerItem : this.domReadyItemsToBeRendered) {
            if (!this.markItemRendered(headerItem)) continue;
            this.getRealResponse().render(headerItem);
        }
        for (OnLoadHeaderItem onLoadHeaderItem : this.loadItemsToBeRendered) {
            if (!this.markItemRendered(onLoadHeaderItem)) continue;
            this.getRealResponse().render(onLoadHeaderItem);
        }
    }

    private boolean markItemRendered(HeaderItem item) {
        if (this.wasRendered(item)) {
            return false;
        }
        if (item instanceof IWrappedHeaderItem) {
            this.getRealResponse().markRendered(((IWrappedHeaderItem)((Object)item)).getWrapped());
        }
        this.getRealResponse().markRendered(item);
        for (HeaderItem headerItem : item.getProvidedResources()) {
            this.getRealResponse().markRendered(headerItem);
        }
        return true;
    }

    private HeaderItem getItemToBeRendered(HeaderItem item) {
        HeaderItem innerItem = item;
        while (innerItem instanceof IWrappedHeaderItem) {
            innerItem = ((IWrappedHeaderItem)((Object)innerItem)).getWrapped();
        }
        if (this.getRealResponse().wasRendered(innerItem)) {
            return NoHeaderItem.get();
        }
        HeaderItem bundle = Application.get().getResourceBundles().findBundle(innerItem);
        if (bundle == null) {
            return item;
        }
        bundle = this.preserveDetails(item, bundle);
        if (item instanceof IWrappedHeaderItem) {
            bundle = ((IWrappedHeaderItem)((Object)item)).wrap(bundle);
        }
        return bundle;
    }

    protected HeaderItem preserveDetails(HeaderItem item, HeaderItem bundle) {
        HeaderItem resultBundle;
        if (item instanceof CssReferenceHeaderItem && bundle instanceof CssReferenceHeaderItem) {
            CssReferenceHeaderItem originalHeaderItem = (CssReferenceHeaderItem)item;
            resultBundle = this.preserveCssDetails(originalHeaderItem, (CssReferenceHeaderItem)bundle);
        } else if (item instanceof JavaScriptReferenceHeaderItem && bundle instanceof JavaScriptReferenceHeaderItem) {
            JavaScriptReferenceHeaderItem originalHeaderItem = (JavaScriptReferenceHeaderItem)item;
            resultBundle = this.preserveJavaScriptDetails(originalHeaderItem, (JavaScriptReferenceHeaderItem)bundle);
        } else {
            resultBundle = bundle;
        }
        return resultBundle;
    }

    private HeaderItem preserveJavaScriptDetails(JavaScriptReferenceHeaderItem item, JavaScriptReferenceHeaderItem bundle) {
        ResourceReference bundleReference = bundle.getReference();
        AbstractCspHeaderItem resultBundle = bundleReference instanceof ReplacementResourceBundleReference ? JavaScriptHeaderItem.forReference(bundleReference, item.getPageParameters(), item.getId()).setCharset(item.getCharset()).setDefer(item.isDefer()).setAsync(item.isAsync()).setNonce(item.getNonce()) : bundle;
        return resultBundle;
    }

    protected HeaderItem preserveCssDetails(CssReferenceHeaderItem item, CssReferenceHeaderItem bundle) {
        ResourceReference bundleReference = bundle.getReference();
        CssReferenceHeaderItem resultBundle = bundleReference instanceof ReplacementResourceBundleReference ? CssHeaderItem.forReference(bundleReference, item.getPageParameters(), item.getMedia()) : bundle;
        return resultBundle;
    }

    public static class RecordedHeaderItem {
        private final HeaderItem item;
        private final List<RecordedHeaderItemLocation> locations;
        private int minDepth = Integer.MAX_VALUE;

        public RecordedHeaderItem(HeaderItem item) {
            this.item = item;
            this.locations = new ArrayList<RecordedHeaderItemLocation>();
        }

        void addLocation(Component renderBase, int indexInRequest) {
            this.locations.add(new RecordedHeaderItemLocation(renderBase, indexInRequest));
            this.minDepth = Integer.MAX_VALUE;
        }

        public HeaderItem getItem() {
            return this.item;
        }

        public List<RecordedHeaderItemLocation> getLocations() {
            return this.locations;
        }

        public int getMinDepth() {
            if (this.minDepth == Integer.MAX_VALUE) {
                for (RecordedHeaderItemLocation location : this.locations) {
                    this.minDepth = Math.min(this.minDepth, location.getDepth());
                }
            }
            return this.minDepth;
        }

        public String toString() {
            return String.valueOf(this.locations) + ":" + String.valueOf(this.item);
        }
    }

    public static class RecordedHeaderItemLocation {
        private final Component renderBase;
        private int indexInRequest;
        private int depth = -1;

        public RecordedHeaderItemLocation(Component renderBase, int indexInRequest) {
            this.renderBase = renderBase;
            this.indexInRequest = indexInRequest;
        }

        public Object getRenderBase() {
            return this.renderBase;
        }

        public int getIndexInRequest() {
            return this.indexInRequest;
        }

        public int getDepth() {
            if (this.depth == -1) {
                for (Component component = this.renderBase; component != null; component = component.getParent()) {
                    ++this.depth;
                }
            }
            return this.depth;
        }

        public String toString() {
            return Classes.simpleName(this.renderBase.getClass());
        }
    }
}

