/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public abstract class MultipartServletWebRequest
extends ServletWebRequest
implements IMultipartWebRequest {
    private Bytes maxSize;
    private Bytes fileMaxSize;
    private long fileCountMax = -1L;

    public MultipartServletWebRequest(HttpServletRequest httpServletRequest, String filterPrefix) {
        super(httpServletRequest, filterPrefix);
    }

    public MultipartServletWebRequest(HttpServletRequest httpServletRequest, String filterPrefix, Url url) {
        super(httpServletRequest, filterPrefix, url);
    }

    public abstract void parseFileParts() throws FileUploadException;

    @Override
    public ServletWebRequest cloneWithUrl(Url url) {
        return new MultipartServletWebRequest(this.getContainerRequest(), this.getFilterPrefix(), url){

            @Override
            public void parseFileParts() throws FileUploadException {
                MultipartServletWebRequest.this.parseFileParts();
            }

            @Override
            public List<FileItem> getFile(String fieldName) {
                return MultipartServletWebRequest.this.getFile(fieldName);
            }

            @Override
            public Map<String, List<FileItem>> getFiles() {
                return MultipartServletWebRequest.this.getFiles();
            }

            @Override
            public IRequestParameters getPostParameters() {
                return MultipartServletWebRequest.this.getPostParameters();
            }
        };
    }

    public Bytes getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Bytes maxSize) {
        Args.notNull((Object)maxSize, (String)"maxSize");
        this.maxSize = maxSize;
    }

    public Bytes getFileMaxSize() {
        return this.fileMaxSize;
    }

    public void setFileMaxSize(Bytes fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    public void setFileCountMax(long fileCountMax) {
        this.fileCountMax = fileCountMax;
    }
}

