/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.xbean.osgi.bundle.util.DictionaryMap;
import org.apache.xbean.osgi.bundle.util.HeaderParser;
import org.apache.xbean.osgi.bundle.util.VersionRange;
import org.osgi.framework.Version;

public class BundleDescription {
    private Map headers;

    public BundleDescription(Manifest manifest) {
        this.headers = BundleDescription.manifestToMap(manifest);
    }

    public BundleDescription(Dictionary dictionary) {
        this.headers = new DictionaryMap(dictionary);
    }

    public BundleDescription(Map headers) {
        this.headers = headers;
    }

    public List<ImportPackage> getImportPackage() {
        String headerValue = (String)this.headers.get("Import-Package");
        ArrayList<ImportPackage> imports = new ArrayList<ImportPackage>();
        List<HeaderParser.HeaderElement> elements = HeaderParser.parseHeader(headerValue);
        for (HeaderParser.HeaderElement element : elements) {
            ImportPackage p = new ImportPackage(element.getName(), element.getAttributes(), element.getDirectives());
            imports.add(p);
        }
        return imports;
    }

    public List<ExportPackage> getExportPackage() {
        String headerValue = (String)this.headers.get("Export-Package");
        ArrayList<ExportPackage> exports = new ArrayList<ExportPackage>();
        List<HeaderParser.HeaderElement> elements = HeaderParser.parseHeader(headerValue);
        for (HeaderParser.HeaderElement element : elements) {
            ExportPackage p = new ExportPackage(element.getName(), element.getAttributes(), element.getDirectives());
            exports.add(p);
        }
        return exports;
    }

    public List<ImportPackage> getExternalImports() {
        List<ImportPackage> imports = this.getImportPackage();
        List<ExportPackage> exports = this.getExportPackage();
        ArrayList<ImportPackage> realImports = new ArrayList<ImportPackage>();
        for (ImportPackage p : imports) {
            if (BundleDescription.isExported(exports, p)) continue;
            realImports.add(p);
        }
        return realImports;
    }

    private static boolean isExported(List<ExportPackage> exports, ImportPackage p) {
        for (ExportPackage export : exports) {
            if (!export.getName().equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public List<RequireBundle> getRequireBundle() {
        String headerValue = (String)this.headers.get("Require-Bundle");
        ArrayList<RequireBundle> requireBundles = new ArrayList<RequireBundle>();
        List<HeaderParser.HeaderElement> elements = HeaderParser.parseHeader(headerValue);
        for (HeaderParser.HeaderElement element : elements) {
            RequireBundle p = new RequireBundle(element.getName(), element.getAttributes(), element.getDirectives());
            requireBundles.add(p);
        }
        return requireBundles;
    }

    public FragmentHost getFragmentHost() {
        String headerValue = (String)this.headers.get("Fragment-Host");
        List<HeaderParser.HeaderElement> elements = HeaderParser.parseHeader(headerValue);
        if (elements.size() == 1) {
            HeaderParser.HeaderElement element = elements.get(0);
            return new FragmentHost(element.getName(), element.getAttributes(), element.getDirectives());
        }
        return null;
    }

    public List<HeaderEntry> getDynamicImportPackage() {
        String headerValue = (String)this.headers.get("DynamicImport-Package");
        return this.parseStandardHeader(headerValue);
    }

    public List<HeaderEntry> getBundleClassPath() {
        String headerValue = (String)this.headers.get("Bundle-ClassPath");
        return this.parseStandardHeader(headerValue);
    }

    public SymbolicName getSymbolicName() {
        String headerValue = (String)this.headers.get("Bundle-SymbolicName");
        List<HeaderParser.HeaderElement> elements = HeaderParser.parseHeader(headerValue);
        if (elements.size() == 1) {
            HeaderParser.HeaderElement element = elements.get(0);
            return new SymbolicName(element.getName(), element.getAttributes(), element.getDirectives());
        }
        return null;
    }

    public Version getVersion() {
        String headerValue = (String)this.headers.get("Bundle-Version");
        return BundleDescription.getVersionRange(headerValue).getLow();
    }

    public Map getHeaders() {
        return this.headers;
    }

    private List<HeaderEntry> parseStandardHeader(String headerValue) {
        ArrayList<HeaderEntry> imports = new ArrayList<HeaderEntry>();
        List<HeaderParser.HeaderElement> elements = HeaderParser.parseHeader(headerValue);
        for (HeaderParser.HeaderElement element : elements) {
            HeaderEntry p = new HeaderEntry(element.getName(), element.getAttributes(), element.getDirectives());
            imports.add(p);
        }
        return imports;
    }

    private static Map<String, String> manifestToMap(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            headers.put(key, value);
        }
        return headers;
    }

    private static VersionRange getVersionRange(String version) {
        if (version == null) {
            version = "0.0.0";
        }
        return VersionRange.parse(version);
    }

    public static class FragmentHost
    extends HeaderEntry {
        private VersionRange versionRange;

        public FragmentHost(String name, Map<String, String> attributes, Map<String, String> directives) {
            super(name, attributes, directives);
            this.versionRange = BundleDescription.getVersionRange(attributes.get("bundle-version"));
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }
    }

    public static class RequireBundle
    extends HeaderEntry {
        private boolean optional;
        private VersionRange versionRange;

        public RequireBundle(String name, Map<String, String> attributes, Map<String, String> directives) {
            super(name, attributes, directives);
            String resolution = directives.get("resolution");
            this.optional = "optional".equals(resolution);
            this.versionRange = BundleDescription.getVersionRange(attributes.get("bundle-version"));
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isMandatory() {
            return !this.optional;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }
    }

    public static class SymbolicName
    extends HeaderEntry {
        public SymbolicName(String name, Map<String, String> attributes, Map<String, String> directives) {
            super(name, attributes, directives);
        }
    }

    public static class ImportPackage
    extends HeaderEntry {
        private boolean optional;
        private VersionRange versionRange;

        public ImportPackage(String name, Map<String, String> attributes, Map<String, String> directives) {
            super(name, attributes, directives);
            String resolution = directives.get("resolution");
            this.optional = "optional".equals(resolution);
            this.versionRange = BundleDescription.getVersionRange(attributes.get("version"));
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isMandatory() {
            return !this.optional;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }
    }

    public static class ExportPackage
    extends HeaderEntry {
        private Version version;

        public ExportPackage(String name, Map<String, String> attributes, Map<String, String> directives) {
            super(name, attributes, directives);
            this.version = BundleDescription.getVersionRange(attributes.get("version")).getLow();
        }

        public Version getVersion() {
            return this.version;
        }
    }

    public static class HeaderEntry {
        private String name;
        private Map<String, String> attributes;
        private Map<String, String> directives;

        public HeaderEntry(String name, Map<String, String> attributes, Map<String, String> directives) {
            this.name = name;
            this.attributes = attributes;
            this.directives = directives;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Name: ").append(this.name);
            builder.append(", Attributes: ").append(this.attributes);
            builder.append(", Directives: ").append(this.directives);
            return builder.toString();
        }
    }
}

