/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.Primitives;

public class ExponentialBackOff
implements BackOff {
    private final long initialDelayInMillis;
    private final long maxDelayInMillis;
    private final int factor;
    private final Jitter jitter;
    private long lastDelay;

    public ExponentialBackOff(long initialDelayInMillis, int factor, Jitter jitter, long maxDelayInMillis) {
        this.initialDelayInMillis = Preconditions.check(initialDelayInMillis, initialDelayInMillis >= 0L, "Initial delay must be >= 0");
        this.factor = Preconditions.check(factor, factor >= 1, "Factor must be >= 1");
        this.jitter = Preconditions.checkNotNull(jitter, "Jitter must be set");
        long l = this.maxDelayInMillis = maxDelayInMillis <= 0L ? Long.MAX_VALUE : maxDelayInMillis;
        if (maxDelayInMillis > 0L) {
            Preconditions.check(initialDelayInMillis, initialDelayInMillis < maxDelayInMillis, "Initial delay must be < max delay");
        }
    }

    @Override
    public synchronized long getInMillis(Throwable cause) {
        if (this.lastDelay == 0L) {
            this.lastDelay = this.initialDelayInMillis;
            return this.lastDelay + this.jitter.generate();
        }
        this.lastDelay *= (long)this.factor;
        return Primitives.clamp(this.lastDelay + this.jitter.generate(), 0L, this.maxDelayInMillis);
    }
}

