/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.geronimo.mail.james.mime4j.Charsets;
import org.apache.geronimo.mail.james.mime4j.io.BinaryInputStream;
import org.apache.geronimo.mail.james.mime4j.io.TextInputStream;
import org.apache.geronimo.mail.james.mime4j.util.ByteArrayBuffer;

public final class InputStreams {
    private InputStreams() {
    }

    public static InputStream create(byte[] b, int off, int len) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(ByteBuffer.wrap(b, off, len));
    }

    public static InputStream create(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(ByteBuffer.wrap(b));
    }

    public static InputStream create(ByteArrayBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(ByteBuffer.wrap(b.buffer(), 0, b.length()));
    }

    public static InputStream create(ByteBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array may not be null");
        }
        return new BinaryInputStream(b);
    }

    public static InputStream createAscii(CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("CharSequence may not be null");
        }
        return new TextInputStream(s, Charsets.US_ASCII, 1024);
    }

    public static InputStream create(CharSequence s, Charset charset) {
        if (s == null) {
            throw new IllegalArgumentException("CharSequence may not be null");
        }
        return new TextInputStream(s, charset != null ? charset : Charsets.DEFAULT_CHARSET, 1024);
    }
}

