/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing.isoline;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.image.processing.isoline.PolylineBuffer;
import org.apache.sis.util.internal.Numerics;

final class Fragments
extends ArrayList<double[]> {
    private Point firstPoint;
    private Point lastPoint;

    Fragments(PolylineBuffer polylineOnLeft, PolylineBuffer polylineOnTop) {
        int index = 0;
        do {
            int n;
            PolylineBuffer polyline;
            PolylineBuffer polylineBuffer = polyline = (index & 2) == 0 ? polylineOnLeft : polylineOnTop;
            if (index % 3 == 0 && polyline != null) {
                polyline = polyline.opposite;
            }
            if (polyline != null && (n = polyline.size) != 0) {
                boolean isLastPoint;
                double x;
                double y;
                double[] coordinates = polyline.coordinates;
                if ((index & 1) == 0) {
                    y = coordinates[--n];
                    x = coordinates[--n];
                } else {
                    x = coordinates[0];
                    y = coordinates[1];
                }
                boolean bl = isLastPoint = index >= 6;
                if (Double.isFinite(x) && Double.isFinite(y)) {
                    Point p = new Point((int)x, (int)y);
                    if (!Numerics.isInteger(x)) {
                        p.x ^= 0xFFFFFFFF;
                    }
                    if (!Numerics.isInteger(y)) {
                        p.y ^= 0xFFFFFFFF;
                    }
                    if (isLastPoint) {
                        this.lastPoint = p;
                        break;
                    }
                    this.firstPoint = p;
                } else if (isLastPoint) {
                    if (this.firstPoint != null) break;
                    return;
                }
                index = 6;
                continue;
            }
            if (++index != 4) continue;
            return;
        } while (index <= 9);
        this.take(polylineOnLeft.opposite);
        this.take(polylineOnLeft);
        if (polylineOnTop != null) {
            PolylineBuffer suffix = polylineOnTop.opposite;
            this.take(polylineOnTop);
            this.take(suffix);
        }
    }

    private void take(PolylineBuffer polyline) {
        if (polyline != null && polyline.size != 0) {
            this.add(Arrays.copyOf(polyline.coordinates, polyline.size));
            polyline.clear();
        } else {
            this.add(null);
        }
    }

    final boolean isExtremity(Point key) {
        return key.equals(this.firstPoint) || key.equals(this.lastPoint);
    }

    final boolean addOrMerge(Map<Point, Fragments> partialPaths) {
        Fragments before = partialPaths.remove(this.firstPoint);
        Fragments after = partialPaths.remove(this.lastPoint);
        if (before != null) {
            partialPaths.remove(this.addAll(before, true));
        }
        if (after != null) {
            partialPaths.remove(this.addAll(after, false));
        }
        if (this.firstPoint != null && this.firstPoint.equals(this.lastPoint)) {
            partialPaths.remove(this.firstPoint);
            partialPaths.remove(this.lastPoint);
            return true;
        }
        if (this.firstPoint != null) {
            partialPaths.put(this.firstPoint, this);
        }
        if (this.lastPoint != null) {
            partialPaths.put(this.lastPoint, this);
        }
        return this.firstPoint == null && this.lastPoint == null;
    }

    private Point addAll(Fragments other, boolean prepend) {
        int r;
        assert (((this.size() | other.size()) & 1) == 0);
        if (this.lastPoint != null && this.lastPoint.equals(other.firstPoint)) {
            r = 0;
        } else if (this.firstPoint != null && this.firstPoint.equals(other.firstPoint)) {
            r = 1;
        } else if (this.lastPoint != null && this.lastPoint.equals(other.lastPoint)) {
            r = 2;
        } else if (this.firstPoint != null && this.firstPoint.equals(other.lastPoint)) {
            r = 3;
        } else {
            throw new AssertionError();
        }
        if (prepend) {
            r ^= 3;
        }
        if ((r & 1) != 0) {
            this.reverse();
        }
        if ((r & 2) != 0) {
            other.reverse();
        }
        if (prepend) {
            this.addAll(0, other);
            this.firstPoint = other.firstPoint;
            return other.lastPoint;
        }
        this.addAll(other);
        this.lastPoint = other.lastPoint;
        return other.firstPoint;
    }

    private void reverse() {
        Collections.reverse(this);
        Point swap = this.firstPoint;
        this.firstPoint = this.lastPoint;
        this.lastPoint = swap;
    }

    final PolylineBuffer[] toPolylines() {
        PolylineBuffer[] polylines = new PolylineBuffer[this.size()];
        for (int i = 0; i < polylines.length; ++i) {
            double[] coordinates = (double[])this.get(i);
            if (coordinates == null) continue;
            polylines[i] = new PolylineBuffer(coordinates);
        }
        return polylines;
    }
}

