/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.util.Collection;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.iso.lineage.DefaultSource;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.apache.sis.util.internal.CollectionsExt;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

final class ResourceLineage {
    private InternationalString description;
    private Citation sourceCitation;
    private DefaultScope scope;
    private ReferenceSystem referenceSystem;
    private Resolution resolution;

    final boolean isEmpty() {
        return this.description == null && this.sourceCitation == null && this.scope == null && this.referenceSystem == null && this.resolution == null;
    }

    ResourceLineage(Metadata source) {
        this.referenceSystem = CollectionsExt.first(source.getReferenceSystemInfo());
        for (Identification identification : CollectionsExt.nonNull(source.getIdentificationInfo())) {
            Citation citation = identification.getCitation();
            if (citation != null) {
                if (this.sourceCitation == null) {
                    this.sourceCitation = citation;
                }
                if (this.description == null) {
                    this.description = citation.getTitle();
                }
            }
            if (this.resolution != null || !(identification instanceof DataIdentification)) continue;
            for (Resolution resolution : CollectionsExt.nonNull(((DataIdentification)identification).getSpatialResolutions())) {
                if (resolution == null) continue;
                this.resolution = resolution;
            }
        }
        ScopeCode level = ResourceLineage.getScopeLevel(source);
        Collection<? extends Extent> collection = Extents.fromIdentificationInfo(source);
        if (level != null || !collection.isEmpty()) {
            this.scope = new DefaultScope(level);
            this.scope.setExtents(collection);
        }
    }

    private static ScopeCode getScopeLevel(Metadata source) {
        ScopeCode level = null;
        for (ScopeCode c : CollectionsExt.nonNull(source.getHierarchyLevels())) {
            if (c == null) continue;
            if (level == null) {
                level = c;
                continue;
            }
            if (level.equals(c)) continue;
            level = null;
            break;
        }
        return level;
    }

    final DefaultSource build() {
        DefaultSource source = new DefaultSource();
        source.setDescription(this.description);
        source.setSourceCitation(this.sourceCitation);
        source.setScope(this.scope);
        source.setSourceReferenceSystem(this.referenceSystem);
        source.setSourceSpatialResolution(this.resolution);
        return source;
    }
}

