/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.provider.ModifiedAzimuthalEquidistant;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class AzimuthalEquidistant
extends NormalizedProjection {
    private static final long serialVersionUID = -6969752149232210847L;
    final double sin\u03c60;
    final double cos\u03c60;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, ModifiedAzimuthalEquidistant.LATITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, ModifiedAzimuthalEquidistant.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, ModifiedAzimuthalEquidistant.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, ModifiedAzimuthalEquidistant.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, null);
    }

    public AzimuthalEquidistant(OperationMethod method, Parameters parameters) {
        this(AzimuthalEquidistant.initializer(method, parameters));
    }

    AzimuthalEquidistant(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = Math.toRadians(initializer.getAndStore(ModifiedAzimuthalEquidistant.LATITUDE_OF_ORIGIN));
        this.cos\u03c60 = Math.cos(\u03c60);
        this.sin\u03c60 = Math.sin(\u03c60);
    }

    AzimuthalEquidistant(AzimuthalEquidistant other) {
        super(null, other);
        this.cos\u03c60 = other.cos\u03c60;
        this.sin\u03c60 = other.sin\u03c60;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03c6\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.cos\u03c60 < 0.7853981633974483 ? Math.acos(this.cos\u03c60) : Math.asin(this.sin\u03c60)};
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double cosc = Math.min(1.0, Math.max(-1.0, this.sin\u03c60 * sin\u03c6 + this.cos\u03c60 * cos\u03c6 * cos\u03bb));
        double c = Math.acos(cosc);
        boolean ind = Math.abs(c) < 1.5706706731410455E-9;
        double k = ind ? 1.0 : c / Math.sin(c);
        double c\u03c6c\u03bb = cos\u03c6 * cos\u03bb;
        double c\u03c6s\u03bb = cos\u03c6 * sin\u03bb;
        double x = k * c\u03c6s\u03bb;
        double y = k * (this.cos\u03c60 * sin\u03c6 - this.sin\u03c60 * c\u03c6c\u03bb);
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        double t = ind ? 0.3333333333333333 : (1.0 / k - cosc) / (1.0 - cosc * cosc);
        double s\u03c6c\u03bb = sin\u03c6 * cos\u03bb;
        double t\u03bb = c\u03c6s\u03bb * this.cos\u03c60 * t;
        double t\u03c6 = (this.cos\u03c60 * s\u03c6c\u03bb - this.sin\u03c60 * cos\u03c6) * t;
        return new Matrix2(x * t\u03bb + k * c\u03c6c\u03bb, x * t\u03c6 - k * sin\u03bb * sin\u03c6, y * t\u03bb + x * this.sin\u03c60, y * t\u03c6 + k * (this.sin\u03c60 * s\u03c6c\u03bb + this.cos\u03c60 * cos\u03c6));
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double D = Math.hypot(x, y);
        double sinD = Math.sin(D);
        double cosD = Math.cos(D);
        dstPts[dstOff] = Math.atan2(x * sinD, this.cos\u03c60 * cosD * D - this.sin\u03c60 * sinD * y);
        dstPts[dstOff + 1] = Math.asin(D == 0.0 ? this.sin\u03c60 : this.sin\u03c60 * cosD + this.cos\u03c60 * sinD * (y / D));
    }
}

