/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;

public abstract class CascadedStoreEvent<E extends CascadedStoreEvent<E>>
extends StoreEvent {
    private static final long serialVersionUID = -1319167650150261418L;

    protected CascadedStoreEvent(Resource resource) {
        super(resource);
    }

    protected abstract E forSource(Resource var1);

    static final class ParentListener<E extends CascadedStoreEvent<E>>
    implements StoreListener<E> {
        private final Class<E> eventType;
        private final StoreListeners parent;
        private final WeakReference<StoreListeners> listeners;

        ParentListener(Class<E> clazz, StoreListeners storeListeners, StoreListeners storeListeners2) {
            this.eventType = clazz;
            this.parent = storeListeners;
            this.listeners = new WeakReference<StoreListeners>(storeListeners2);
        }

        @Override
        public void eventOccured(E e) {
            StoreListeners storeListeners = (StoreListeners)this.listeners.get();
            if (storeListeners == null) {
                this.parent.removeListener(this.eventType, this);
            } else {
                try {
                    Object e2 = ((CascadedStoreEvent)e).forSource(storeListeners.getSource());
                    ((StoreEvent)e2).consume(true);
                    StoreListeners.fire(storeListeners, this.eventType, e2);
                }
                catch (ExecutionException executionException) {
                    StoreListeners.canNotNotify("fire (cascade)", executionException);
                }
            }
        }
    }
}

