/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.SignReversalComment;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

@XmlTransient
final class InverseOperationMethod
extends DefaultOperationMethod {
    private static final long serialVersionUID = 6395008927817202180L;
    private final OperationMethod inverse;

    private InverseOperationMethod(Map<String, ?> map, OperationMethod operationMethod) {
        super(map, operationMethod.getTargetDimensions(), operationMethod.getSourceDimensions(), operationMethod.getParameters());
        this.inverse = operationMethod;
    }

    static OperationMethod create(OperationMethod operationMethod, DefaultCoordinateOperationFactory defaultCoordinateOperationFactory) throws FactoryException {
        Object object;
        AbstractProvider abstractProvider;
        if (operationMethod instanceof InverseOperationMethod) {
            return ((InverseOperationMethod)operationMethod).inverse;
        }
        if (!(operationMethod instanceof AbstractProvider)) {
            try {
                operationMethod = defaultCoordinateOperationFactory.getOperationMethod(operationMethod.getName().getCode());
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
                CoordinateOperationRegistry.recoverableException("inverse", noSuchIdentifierException);
            }
        }
        if (operationMethod instanceof AbstractProvider && (abstractProvider = ((AbstractProvider)operationMethod).inverse()) != null) {
            return abstractProvider;
        }
        boolean bl = false;
        Object object2 = operationMethod.getParameters().descriptors().iterator();
        while (object2.hasNext() && (bl = (object = object2.next()).getRemarks() instanceof SignReversalComment)) {
        }
        if (bl) {
            return operationMethod;
        }
        object2 = operationMethod.getName();
        object2 = new ImmutableIdentifier(null, null, "Inverse of " + object2.getCode());
        object = new HashMap(6);
        object.put("name", object2);
        object.put("formula", operationMethod.getFormula());
        object.put("remarks", operationMethod.getRemarks());
        if (operationMethod instanceof Deprecable) {
            object.put("deprecated", ((Deprecable)((Object)operationMethod)).isDeprecated());
        }
        return new InverseOperationMethod((Map<String, ?>)object, operationMethod);
    }

    static void properties(SingleOperation singleOperation, Map<String, Object> map) {
        map.put("domainOfValidity", singleOperation.getDomainOfValidity());
        Collection<PositionalAccuracy> collection = singleOperation.getCoordinateOperationAccuracy();
        if (!Containers.isNullOrEmpty(collection)) {
            map.put("coordinateOperationAccuracy", collection.toArray(new PositionalAccuracy[collection.size()]));
        }
        ParameterValueGroup parameterValueGroup = singleOperation.getParameterValues();
        ParameterValueGroup parameterValueGroup2 = parameterValueGroup.getDescriptor().createValue();
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            GeneralParameterDescriptor generalParameterDescriptor;
            InternationalString internationalString;
            ParameterValue parameterValue;
            Object t;
            if (generalParameterValue instanceof ParameterValue && (t = (parameterValue = (ParameterValue)generalParameterValue).getValue()) instanceof Number && (internationalString = (generalParameterDescriptor = parameterValue.getDescriptor()).getRemarks()) != SignReversalComment.SAME) {
                if (internationalString != SignReversalComment.OPPOSITE) {
                    return;
                }
                ParameterValue<?> parameterValue2 = parameterValueGroup2.parameter(generalParameterDescriptor.getName().getCode());
                Unit<?> unit = parameterValue.getUnit();
                if (unit != null) {
                    parameterValue2.setValue(-parameterValue.doubleValue(), unit);
                    continue;
                }
                if (t instanceof Integer || t instanceof Short || t instanceof Byte) {
                    parameterValue2.setValue(-parameterValue.intValue());
                    continue;
                }
                parameterValue2.setValue(-parameterValue.doubleValue());
                continue;
            }
            parameterValueGroup2.values().add(generalParameterValue);
        }
        map.put("parameters", parameterValueGroup2);
    }
}

